/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.node.kubernetes.keystoreloader;

import io.gravitee.common.util.KeyStoreUtils;
import io.gravitee.kubernetes.client.KubernetesClient;
import io.gravitee.kubernetes.client.api.ResourceQuery;
import io.gravitee.kubernetes.client.api.WatchQuery;
import io.gravitee.kubernetes.client.model.v1.Event;
import io.gravitee.kubernetes.client.model.v1.Secret;
import io.gravitee.node.api.certificate.KeyStoreLoaderOptions;
import io.gravitee.node.kubernetes.keystoreloader.AbstractKubernetesKeyStoreLoader;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.CompletableSource;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.schedulers.Schedulers;
import java.security.KeyStore;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class KubernetesSecretKeyStoreLoader
extends AbstractKubernetesKeyStoreLoader<Secret> {
    private static final List<String> SUPPORTED_TYPES = Arrays.asList("JKS".toLowerCase(), "PEM".toLowerCase(), "PKCS12".toLowerCase());
    private static final Pattern SECRET_PATTERN = Pattern.compile("^(.*)/secrets/(.*)$");
    private static final Pattern SECRET_OPAQUE_PATTERN = Pattern.compile("^(.*/secrets/[^/]*)/.*$");
    protected static final String KUBERNETES_TLS_SECRET = "kubernetes.io/tls";
    protected static final String KUBERNETES_OPAQUE_SECRET = "Opaque";
    protected static final String KUBERNETES_TLS_CRT = "tls.crt";
    protected static final String KUBERNETES_TLS_KEY = "tls.key";

    public KubernetesSecretKeyStoreLoader(KeyStoreLoaderOptions options, KubernetesClient kubernetesClient) {
        super(options, kubernetesClient);
        this.prepareLocations();
    }

    private void prepareLocations() {
        this.options.getKubernetesLocations().forEach(location -> {
            Matcher matcher = SECRET_OPAQUE_PATTERN.matcher((CharSequence)location);
            if (matcher.matches()) {
                this.resources.put(matcher.group(1), ResourceQuery.from((String)location).build());
            } else {
                this.resources.put(location, ResourceQuery.from((String)location).build());
            }
        });
    }

    public static boolean canHandle(KeyStoreLoaderOptions options) {
        List kubernetesLocations = options.getKubernetesLocations();
        return kubernetesLocations != null && !kubernetesLocations.isEmpty() && SUPPORTED_TYPES.contains(options.getKeyStoreType().toLowerCase()) && kubernetesLocations.stream().allMatch(location -> SECRET_PATTERN.matcher((CharSequence)location).matches());
    }

    @Override
    protected Completable init() {
        List locationObs = this.resources.keySet().stream().map(location -> this.kubernetesClient.get(ResourceQuery.from((String)location).build()).observeOn(Schedulers.computation()).flatMapCompletable(this::loadKeyStore)).collect(Collectors.toList());
        return Completable.merge(locationObs).observeOn(Schedulers.computation()).andThen((CompletableSource)Completable.fromRunnable(this::refreshKeyStoreBundle));
    }

    @Override
    protected Flowable<Secret> watch() {
        List toWatch = this.resources.keySet().stream().map(location -> this.kubernetesClient.watch(WatchQuery.from((String)location).build()).observeOn(Schedulers.computation()).repeat().retryWhen(errors -> errors.delay(10000L, TimeUnit.MILLISECONDS))).collect(Collectors.toList());
        return Flowable.merge(toWatch).filter(event -> event.getType().equalsIgnoreCase("MODIFIED")).map(Event::getObject);
    }

    @Override
    protected Completable loadKeyStore(Secret secret) {
        KeyStore keyStore;
        Map data = secret.getData();
        if (secret.getType().equals(KUBERNETES_TLS_SECRET)) {
            keyStore = KeyStoreUtils.initFromPem((String)new String(Base64.getDecoder().decode((String)data.get(KUBERNETES_TLS_CRT))), (String)new String(Base64.getDecoder().decode((String)data.get(KUBERNETES_TLS_KEY))), (String)this.options.getKeyStorePassword(), (String)secret.getMetadata().getName());
        } else if (secret.getType().equals(KUBERNETES_OPAQUE_SECRET)) {
            if (this.options.getKeyStoreType().equalsIgnoreCase("PEM")) {
                return Completable.error((Throwable)new IllegalArgumentException("Pem format is not supported with opaque secret, use kubernetes tls secret instead."));
            }
            Optional<ResourceQuery> optResource = this.resources.values().stream().filter(r -> r.getNamespace().equalsIgnoreCase(secret.getMetadata().getNamespace()) && (secret.getType().equalsIgnoreCase(KUBERNETES_OPAQUE_SECRET) || r.getType().getName().equalsIgnoreCase(secret.getType())) && r.getResource().equalsIgnoreCase(secret.getMetadata().getName())).findFirst();
            if (optResource.isEmpty()) {
                return Completable.error((Throwable)new IllegalArgumentException("Unable to load keystore: unknown secret."));
            }
            if (optResource.get().getResourceKey() == null || optResource.get().getResourceKey().isEmpty()) {
                return Completable.error((Throwable)new IllegalArgumentException("You must specify a data when using opaque secret (ex: /my-namespace/secrets/my-secret/my-keystore)."));
            }
            keyStore = KeyStoreUtils.initFromContent((String)this.options.getKeyStoreType(), (String)((String)data.get(optResource.get().getResourceKey())), (String)this.options.getKeyStorePassword());
        } else {
            return Completable.error((Throwable)new IllegalArgumentException(String.format("Invalid secret type [%s]", secret.getType())));
        }
        this.keyStoresByLocation.put(secret.getMetadata().getUid(), keyStore);
        return Completable.complete();
    }
}

