/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.node.management.http.node;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.gravitee.common.http.HttpMethod;
import io.gravitee.common.util.Version;
import io.gravitee.node.api.Node;
import io.gravitee.node.management.http.endpoint.ManagementEndpoint;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.json.Json;
import io.vertx.core.json.jackson.DatabindCodec;
import io.vertx.ext.web.RoutingContext;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class NodeEndpoint
implements ManagementEndpoint {
    private final Logger LOGGER = LoggerFactory.getLogger(NodeEndpoint.class);
    @Autowired
    private Node node;

    @Override
    public HttpMethod method() {
        return HttpMethod.GET;
    }

    @Override
    public String path() {
        return "/";
    }

    @Override
    public void handle(RoutingContext ctx) {
        final HttpServerResponse response = ctx.response();
        response.setStatusCode(200);
        response.putHeader("Content-Type", "application/json");
        response.setChunked(true);
        NodeInfos data = new NodeInfos();
        data.setId(this.node.id());
        data.setName(this.node.name());
        data.setVersion(Version.RUNTIME_VERSION);
        data.setMetadata(this.node.metadata());
        DatabindCodec codec = (DatabindCodec)Json.CODEC;
        codec.prettyMapper().setSerializationInclusion(JsonInclude.Include.NON_NULL);
        response.write(codec.toString((Object)data, true), (Handler)new Handler<AsyncResult<Void>>(){

            public void handle(AsyncResult<Void> event) {
                if (event.failed()) {
                    response.setStatusCode(500);
                    NodeEndpoint.this.LOGGER.error("Unable to transform data object to JSON", event.cause());
                }
                response.end();
            }
        });
    }

    public static class NodeInfos {
        private String id;
        private String name;
        private Map<String, Object> metadata;
        private Version version;

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Map<String, Object> getMetadata() {
            return this.metadata;
        }

        public void setMetadata(Map<String, Object> metadata) {
            this.metadata = metadata;
        }

        public Version getVersion() {
            return this.version;
        }

        public void setVersion(Version version) {
            this.version = version;
        }
    }
}

