/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.node.management.http.vertx.verticle;

import io.gravitee.node.management.http.configuration.ConfigurationEndpoint;
import io.gravitee.node.management.http.endpoint.ManagementEndpointManager;
import io.gravitee.node.management.http.metrics.prometheus.PrometheusEndpoint;
import io.gravitee.node.management.http.node.NodeEndpoint;
import io.gravitee.node.management.http.vertx.configuration.HttpServerConfiguration;
import io.vertx.core.AbstractVerticle;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpServer;
import io.vertx.ext.auth.AuthProvider;
import io.vertx.ext.auth.authentication.AuthenticationProvider;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.handler.BasicAuthHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.env.Environment;

public class ManagementVerticle
extends AbstractVerticle {
    private static final Logger LOGGER = LoggerFactory.getLogger(ManagementVerticle.class);
    private static final String PATH = "/_node";
    private static final String WEBHOOK_PATH = "/hooks";
    private static final String AUTHENTICATION_TYPE_NONE = "none";
    private static final String AUTHENTICATION_TYPE_BASIC = "basic";
    private static final String AUTHENTICATION_BASIC_REALM = "gravitee.io";
    @Autowired
    @Qualifier(value="managementHttpServer")
    private HttpServer httpServer;
    @Autowired
    @Qualifier(value="managementRouter")
    private Router nodeRouter;
    @Autowired
    @Qualifier(value="managementWebhookRouter")
    private Router nodeWebhookRouter;
    @Autowired
    private Vertx vertx;
    @Autowired
    @Qualifier(value="managementAuthProvider")
    private AuthProvider authProvider;
    @Autowired
    private HttpServerConfiguration httpServerConfiguration;
    @Autowired
    private NodeEndpoint nodeEndpoint;
    @Autowired
    private ConfigurationEndpoint configurationEndpoint;
    @Autowired
    private PrometheusEndpoint prometheusEndpoint;
    @Autowired
    private ManagementEndpointManager managementEndpointManager;
    @Autowired
    private Environment environment;

    public void start(Promise<Void> promise) throws Exception {
        if (this.httpServerConfiguration.isEnabled()) {
            this.doStart(promise);
        } else {
            promise.complete();
            LOGGER.info("Node Management API is disabled, skipping...");
        }
    }

    public void stop(final Promise<Void> promise) throws Exception {
        if (this.httpServerConfiguration.isEnabled()) {
            LOGGER.info("Stopping Management API...");
            this.httpServer.close((Handler)new Handler<AsyncResult<Void>>(){

                public void handle(AsyncResult<Void> event) {
                    if (event.succeeded()) {
                        LOGGER.info("HTTP Server has been correctly stopped");
                        promise.complete();
                    } else {
                        LOGGER.error("Unexpected error while stopping HTTP listener for Node Management API", event.cause());
                        promise.fail(event.cause());
                    }
                }
            });
        }
    }

    private void doStart(Promise<Void> promise) throws Exception {
        LOGGER.info("Start HTTP listener for Node Management API");
        Router mainRouter = Router.router((Vertx)this.vertx);
        mainRouter.mountSubRouter(WEBHOOK_PATH, this.nodeWebhookRouter);
        mainRouter.mountSubRouter(PATH, this.nodeRouter);
        BasicAuthHandler authHandler = null;
        switch (this.httpServerConfiguration.getAuthenticationType().toLowerCase()) {
            case "none": {
                break;
            }
            case "basic": {
                authHandler = BasicAuthHandler.create((AuthenticationProvider)this.authProvider, (String)AUTHENTICATION_BASIC_REALM);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported Authentication type " + this.httpServerConfiguration.getAuthenticationType() + " for HTTP core services");
            }
        }
        if (authHandler != null) {
            mainRouter.route().order(-1).handler((Handler)authHandler);
            this.nodeRouter.route().order(-1).handler((Handler)authHandler);
        }
        mainRouter.route().handler(ctx -> ctx.fail(404));
        this.httpServer.requestHandler((Handler)mainRouter).listen(event -> {
            if (event.failed()) {
                LOGGER.error("HTTP listener for Node Management can not be started properly", event.cause());
                promise.fail(event.cause());
            } else {
                boolean prometheusEnabled;
                this.managementEndpointManager.register(this.nodeEndpoint);
                this.managementEndpointManager.register(this.configurationEndpoint);
                boolean metricsEnabled = (Boolean)this.environment.getProperty("services.metrics.enabled", Boolean.class, (Object)false);
                if (metricsEnabled && (prometheusEnabled = ((Boolean)this.environment.getProperty("services.metrics.prometheus.enabled", Boolean.class, (Object)true)).booleanValue())) {
                    this.managementEndpointManager.register(this.prometheusEndpoint);
                }
                LOGGER.info("HTTP listener for Node Management bind to port TCP:{}", (Object)((HttpServer)event.result()).actualPort());
                promise.complete();
            }
        });
    }
}

