/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.node.tracing;

import io.gravitee.node.api.tracing.Tracer;
import io.gravitee.plugin.core.api.Plugin;
import io.gravitee.plugin.core.api.PluginClassLoader;
import io.gravitee.plugin.core.api.PluginClassLoaderFactory;
import io.gravitee.plugin.core.api.PluginContextFactory;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.core.env.Environment;

public class TracingService
implements InitializingBean {
    private final Logger logger = LoggerFactory.getLogger(TracingService.class);
    private final List<TracerListener> listeners = new ArrayList<TracerListener>();
    @Autowired
    private PluginClassLoaderFactory pluginClassLoaderFactory;
    @Autowired
    private Environment environment;
    @Autowired
    private PluginContextFactory pluginContextFactory;

    public void register(Plugin plugin) {
        String tracerType = this.environment.getProperty("services.tracing.type");
        if (tracerType != null && plugin.id().contains(tracerType)) {
            try {
                PluginClassLoader classLoader = this.pluginClassLoaderFactory.getOrCreateClassLoader(plugin);
                Class clazz = classLoader.loadClass(plugin.clazz());
                ApplicationContext context = this.pluginContextFactory.create(plugin);
                Tracer tracer = (Tracer)context.getBean(clazz);
                tracer.start();
                for (TracerListener listener : this.listeners) {
                    listener.onRegister(tracer);
                }
            }
            catch (Exception ex) {
                this.logger.error("Unable to create an instance of Tracer: {}", (Object)plugin.id(), (Object)ex);
            }
        } else {
            this.logger.warn("Tracing support is enabled for tracer name[{}]. Skipping the {} tracer installation", (Object)tracerType, (Object)plugin.id());
        }
    }

    public void addTracerListener(TracerListener listener) {
        this.listeners.add(listener);
    }

    public void afterPropertiesSet() throws Exception {
        String tracerType = this.environment.getProperty("services.tracing.type");
        this.logger.info("Tracing support is enabled with tracer: name[{}]", (Object)tracerType);
    }

    public static interface TracerListener {
        public void onRegister(Tracer var1);
    }
}

