/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.node.tracing.plugin;

import io.gravitee.node.tracing.TracingService;
import io.gravitee.plugin.core.api.AbstractPluginHandler;
import io.gravitee.plugin.core.api.Plugin;
import io.gravitee.plugin.core.api.PluginClassLoaderFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;

public class TracingPluginHandler
extends AbstractPluginHandler {
    @Autowired
    private PluginClassLoaderFactory<Plugin> pluginClassLoaderFactory;
    @Autowired
    private TracingService tracingService;
    @Autowired
    private Environment environment;

    public boolean canHandle(Plugin plugin) {
        return (Boolean)this.environment.getProperty("services.tracing.enabled", Boolean.class, (Object)false) != false && "tracer".equalsIgnoreCase(plugin.type());
    }

    protected String type() {
        return "tracers";
    }

    protected ClassLoader getClassLoader(Plugin plugin) throws Exception {
        return this.pluginClassLoaderFactory.getOrCreateClassLoader(plugin, ((Object)((Object)this)).getClass().getClassLoader());
    }

    protected void handle(Plugin plugin, Class<?> aClass) {
        this.tracingService.register(plugin);
    }
}

