/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.node.vertx;

import io.gravitee.node.api.Node;
import io.gravitee.node.tracing.vertx.LazyVertxTracerFactory;
import io.gravitee.node.vertx.verticle.factory.SpringVerticleFactory;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.binder.jvm.ClassLoaderMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmGcMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmMemoryMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmThreadMetrics;
import io.micrometer.core.instrument.binder.system.FileDescriptorMetrics;
import io.micrometer.core.instrument.binder.system.ProcessorMetrics;
import io.micrometer.core.instrument.config.MeterFilter;
import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.metrics.MetricsOptions;
import io.vertx.core.spi.VerticleFactory;
import io.vertx.core.spi.VertxTracerFactory;
import io.vertx.core.tracing.TracingOptions;
import io.vertx.micrometer.Label;
import io.vertx.micrometer.MetricsDomain;
import io.vertx.micrometer.MicrometerMetricsOptions;
import io.vertx.micrometer.VertxPrometheusOptions;
import io.vertx.micrometer.backends.BackendRegistries;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;

public class VertxFactory
implements FactoryBean<Vertx> {
    private static final Logger LOGGER = LoggerFactory.getLogger(VertxFactory.class);
    @Autowired
    private Node node;
    @Autowired
    private Environment environment;
    @Autowired
    private SpringVerticleFactory springVerticleFactory;
    @Autowired
    private LazyVertxTracerFactory vertxTracerFactory;

    public Vertx getObject() throws Exception {
        boolean tracingEnabled;
        LOGGER.debug("Creating a new instance of Vert.x");
        VertxOptions options = this.getVertxOptions();
        boolean metricsEnabled = (Boolean)this.environment.getProperty("services.metrics.enabled", Boolean.class, (Object)false);
        if (metricsEnabled) {
            this.configureMetrics(options);
        }
        if (tracingEnabled = ((Boolean)this.environment.getProperty("services.tracing.enabled", Boolean.class, (Object)false)).booleanValue()) {
            this.configureTracing(options);
        }
        Vertx instance = Vertx.vertx((VertxOptions)options);
        instance.registerVerticleFactory((VerticleFactory)this.springVerticleFactory);
        if (metricsEnabled) {
            MeterRegistry registry = BackendRegistries.getDefaultNow();
            registry.config().meterFilter((MeterFilter)new RenameVertxFilter()).commonTags(new String[]{"application", this.node.application()}).commonTags(new String[]{"instance", this.node.hostname()});
            new FileDescriptorMetrics().bindTo(registry);
            new ClassLoaderMetrics().bindTo(registry);
            new JvmMemoryMetrics().bindTo(registry);
            new JvmGcMetrics().bindTo(registry);
            new ProcessorMetrics().bindTo(registry);
            new JvmThreadMetrics().bindTo(registry);
        }
        return instance;
    }

    private void configureMetrics(VertxOptions options) {
        LOGGER.info("Metrics support is enabled");
        MicrometerMetricsOptions micrometerMetricsOptions = new MicrometerMetricsOptions();
        micrometerMetricsOptions.setDisabledMetricsCategories(new HashSet<String>(Arrays.asList(MetricsDomain.DATAGRAM_SOCKET.toCategory(), MetricsDomain.NAMED_POOLS.toCategory(), MetricsDomain.VERTICLES.toCategory(), MetricsDomain.EVENT_BUS.toCategory()))).setEnabled(true);
        Set<String> labels = this.loadLabels();
        if (labels != null && !labels.isEmpty()) {
            Set micrometerLabels = labels.stream().map(label -> Label.valueOf((String)label.toUpperCase())).collect(Collectors.toSet());
            micrometerMetricsOptions.setLabels(micrometerLabels);
        } else {
            micrometerMetricsOptions.setLabels(EnumSet.of(Label.LOCAL, Label.HTTP_METHOD, Label.HTTP_CODE));
        }
        boolean prometheusEnabled = (Boolean)this.environment.getProperty("services.metrics.prometheus.enabled", Boolean.class, (Object)true);
        if (prometheusEnabled) {
            LOGGER.info("Prometheus metrics support is enabled");
            micrometerMetricsOptions.setPrometheusOptions(new VertxPrometheusOptions().setEnabled(true));
        }
        options.setMetricsOptions((MetricsOptions)micrometerMetricsOptions);
    }

    private void configureTracing(VertxOptions options) {
        options.setTracingOptions(new TracingOptions().setFactory((VertxTracerFactory)this.vertxTracerFactory));
    }

    public Class<?> getObjectType() {
        return Vertx.class;
    }

    public boolean isSingleton() {
        return true;
    }

    private Set<String> loadLabels() {
        LOGGER.debug("Looking for metrics labels...");
        HashSet<String> labels = null;
        boolean found = true;
        int idx = 0;
        while (found) {
            String label = this.environment.getProperty("services.metrics.labels[" + idx + "]");
            boolean bl = found = label != null;
            if (found) {
                if (labels == null) {
                    labels = new HashSet<String>();
                }
                labels.add(label);
            }
            ++idx;
        }
        return labels;
    }

    private VertxOptions getVertxOptions() {
        Long warningExceptionTime;
        Long maxEventLoopExecuteTime;
        VertxOptions options = new VertxOptions();
        options.setPreferNativeTransport(true);
        Long blockedThreadCheckInterval = Long.getLong("vertx.options.blockedThreadCheckInterval");
        if (blockedThreadCheckInterval != null) {
            options.setBlockedThreadCheckInterval(blockedThreadCheckInterval.longValue());
        }
        if ((maxEventLoopExecuteTime = Long.getLong("vertx.options.maxEventLoopExecuteTime")) != null) {
            options.setMaxEventLoopExecuteTime(maxEventLoopExecuteTime.longValue());
        }
        if ((warningExceptionTime = Long.getLong("vertx.options.warningExceptionTime")) != null) {
            options.setWarningExceptionTime(warningExceptionTime.longValue());
        }
        return options;
    }

    private class RenameVertxFilter
    implements MeterFilter {
        private RenameVertxFilter() {
        }

        public Meter.Id map(Meter.Id id) {
            if (id.getName().startsWith("vertx.")) {
                return id.withName(id.getName().substring(6));
            }
            return id;
        }
    }
}

