/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.plugin.notifier.internal;

import io.gravitee.plugin.core.api.AbstractSimplePluginHandler;
import io.gravitee.plugin.core.api.ConfigurablePluginManager;
import io.gravitee.plugin.core.api.Plugin;
import io.gravitee.plugin.notifier.NotifierPlugin;
import io.gravitee.plugin.notifier.internal.NotifierPluginImpl;
import io.gravitee.plugin.notifier.internal.NotifierResourceConfigurationClassFinder;
import java.io.IOException;
import java.net.URLClassLoader;
import org.springframework.beans.factory.annotation.Autowired;

public class NotifierPluginHandler
extends AbstractSimplePluginHandler<NotifierPlugin> {
    @Autowired
    private ConfigurablePluginManager<NotifierPlugin> notifierPluginManager;

    public boolean canHandle(Plugin plugin) {
        return "notifier".equalsIgnoreCase(plugin.type());
    }

    protected String type() {
        return "notifiers";
    }

    protected NotifierPlugin create(Plugin plugin, Class<?> pluginClass) {
        NotifierPluginImpl notifierPlugin = new NotifierPluginImpl(plugin, pluginClass);
        notifierPlugin.setConfiguration(new NotifierResourceConfigurationClassFinder().lookupFirst(pluginClass));
        return notifierPlugin;
    }

    protected void register(NotifierPlugin plugin) {
        this.notifierPluginManager.register((Plugin)plugin);
        URLClassLoader classLoader = (URLClassLoader)plugin.notifier().getClassLoader();
        try {
            classLoader.close();
        }
        catch (IOException e) {
            this.logger.error("Unexpected exception while trying to release the notifier classloader");
        }
    }

    protected ClassLoader getClassLoader(Plugin plugin) throws Exception {
        return new URLClassLoader(plugin.dependencies(), ((Object)((Object)this)).getClass().getClassLoader());
    }
}

