/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.services.ratelimit;

import io.gravitee.common.service.AbstractService;
import io.gravitee.gateway.services.ratelimit.AsyncRateLimitRepository;
import io.gravitee.gateway.services.ratelimit.DefaultRateLimitService;
import io.gravitee.gateway.services.ratelimit.LocalRateLimitRepository;
import io.gravitee.gateway.services.ratelimit.rx.SchedulerProvider;
import io.gravitee.repository.ratelimit.api.RateLimitRepository;
import io.gravitee.repository.ratelimit.api.RateLimitService;
import io.gravitee.repository.ratelimit.model.RateLimit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.ConfigurableApplicationContext;

public class AsyncRateLimitService
extends AbstractService {
    private static final Logger LOGGER = LoggerFactory.getLogger(AsyncRateLimitService.class);
    @Value(value="${services.ratelimit.enabled:true}")
    private boolean enabled;

    protected void doStart() throws Exception {
        super.doStart();
        DefaultListableBeanFactory beanFactory = (DefaultListableBeanFactory)((ConfigurableApplicationContext)this.applicationContext).getBeanFactory();
        DefaultListableBeanFactory parentBeanFactory = (DefaultListableBeanFactory)((ConfigurableApplicationContext)this.applicationContext.getParent()).getBeanFactory();
        RateLimitRepository rateLimitRepository = (RateLimitRepository)parentBeanFactory.getBean(RateLimitRepository.class);
        LOGGER.debug("Rate-limit repository implementation is {}", (Object)rateLimitRepository.getClass().getName());
        if (this.enabled) {
            LocalRateLimitRepository localCacheRateLimitRepository = new LocalRateLimitRepository();
            LOGGER.debug("Register rate-limit repository asynchronous implementation {}", (Object)AsyncRateLimitRepository.class.getName());
            AsyncRateLimitRepository asyncRateLimitRepository = new AsyncRateLimitRepository(new SchedulerProvider());
            beanFactory.autowireBean((Object)asyncRateLimitRepository);
            asyncRateLimitRepository.setLocalCacheRateLimitRepository(localCacheRateLimitRepository);
            asyncRateLimitRepository.setRemoteCacheRateLimitRepository((RateLimitRepository<RateLimit>)rateLimitRepository);
            asyncRateLimitRepository.initialize();
            LOGGER.info("Register the rate-limit service bridge for synchronous and asynchronous mode");
            DefaultRateLimitService rateLimitService = new DefaultRateLimitService();
            rateLimitService.setRateLimitRepository((RateLimitRepository<RateLimit>)rateLimitRepository);
            rateLimitService.setAsyncRateLimitRepository(asyncRateLimitRepository);
            parentBeanFactory.registerSingleton(RateLimitService.class.getName(), (Object)rateLimitService);
        } else {
            LOGGER.info("Register the rate-limit service bridge for strict mode only");
            DefaultRateLimitService rateLimitService = new DefaultRateLimitService();
            rateLimitService.setRateLimitRepository((RateLimitRepository<RateLimit>)rateLimitRepository);
            rateLimitService.setAsyncRateLimitRepository((RateLimitRepository<RateLimit>)rateLimitRepository);
            parentBeanFactory.registerSingleton(RateLimitService.class.getName(), (Object)rateLimitService);
        }
    }

    protected void doStop() throws Exception {
        if (this.enabled) {
            super.doStop();
        }
    }

    protected String name() {
        return "Asynchronous Rate Limit proxy";
    }
}

