/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.policy.callout;

import io.gravitee.common.http.HttpMethod;
import io.gravitee.el.TemplateEngine;
import io.gravitee.gateway.api.ExecutionContext;
import io.gravitee.gateway.api.Request;
import io.gravitee.gateway.api.Response;
import io.gravitee.gateway.api.buffer.Buffer;
import io.gravitee.gateway.api.el.EvaluableRequest;
import io.gravitee.gateway.api.el.EvaluableResponse;
import io.gravitee.gateway.api.stream.BufferedReadWriteStream;
import io.gravitee.gateway.api.stream.ReadWriteStream;
import io.gravitee.gateway.api.stream.SimpleReadWriteStream;
import io.gravitee.policy.api.PolicyChain;
import io.gravitee.policy.api.PolicyResult;
import io.gravitee.policy.api.annotations.OnRequest;
import io.gravitee.policy.api.annotations.OnRequestContent;
import io.gravitee.policy.api.annotations.OnResponse;
import io.gravitee.policy.api.annotations.OnResponseContent;
import io.gravitee.policy.callout.CalloutResponse;
import io.gravitee.policy.callout.configuration.CalloutHttpPolicyConfiguration;
import io.gravitee.policy.callout.configuration.PolicyScope;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.RequestOptions;
import io.vertx.core.net.ProxyOptions;
import io.vertx.core.net.ProxyType;
import java.net.URI;
import java.util.Objects;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;

public class CalloutHttpPolicy {
    private static final Logger LOGGER = LoggerFactory.getLogger(CalloutHttpPolicy.class);
    private static final String HTTPS_SCHEME = "https";
    private static final String CALLOUT_EXIT_ON_ERROR = "CALLOUT_EXIT_ON_ERROR";
    private static final String CALLOUT_HTTP_ERROR = "CALLOUT_HTTP_ERROR";
    private CalloutHttpPolicyConfiguration configuration;
    private static final String TEMPLATE_VARIABLE = "calloutResponse";
    private static final String REQUEST_TEMPLATE_VARIABLE = "request";
    private static final String RESPONSE_TEMPLATE_VARIABLE = "response";

    public CalloutHttpPolicy(CalloutHttpPolicyConfiguration configuration) {
        this.configuration = configuration;
    }

    @OnRequest
    public void onRequest(Request request, Response response, ExecutionContext context, PolicyChain policyChain) {
        if (this.configuration.getScope() == null || this.configuration.getScope() == PolicyScope.REQUEST) {
            this.initRequestResponseProperties(context);
            this.doCallout(context, __ -> policyChain.doNext(request, response), arg_0 -> ((PolicyChain)policyChain).failWith(arg_0));
        } else {
            policyChain.doNext(request, response);
        }
    }

    @OnResponse
    public void onResponse(Request request, Response response, ExecutionContext context, PolicyChain policyChain) {
        if (this.configuration.getScope() == PolicyScope.RESPONSE) {
            this.initRequestResponseProperties(context);
            this.doCallout(context, __ -> policyChain.doNext(request, response), arg_0 -> ((PolicyChain)policyChain).failWith(arg_0));
        } else {
            policyChain.doNext(request, response);
        }
    }

    private void initRequestResponseProperties(ExecutionContext context) {
        this.initRequestResponseProperties(context, null, null);
    }

    private void initRequestResponseProperties(ExecutionContext context, String requestContent, String responseContent) {
        context.getTemplateEngine().getTemplateContext().setVariable(REQUEST_TEMPLATE_VARIABLE, (Object)new EvaluableRequest(context.request(), requestContent));
        context.getTemplateEngine().getTemplateContext().setVariable(RESPONSE_TEMPLATE_VARIABLE, (Object)new EvaluableResponse(context.response(), responseContent));
    }

    @OnRequestContent
    public ReadWriteStream onRequestContent(ExecutionContext context, PolicyChain policyChain) {
        if (this.configuration.getScope() == PolicyScope.REQUEST_CONTENT) {
            return this.createStream(PolicyScope.REQUEST_CONTENT, context, policyChain);
        }
        return null;
    }

    @OnResponseContent
    public ReadWriteStream onResponseContent(ExecutionContext context, PolicyChain policyChain) {
        if (this.configuration.getScope() == PolicyScope.RESPONSE_CONTENT) {
            return this.createStream(PolicyScope.RESPONSE_CONTENT, context, policyChain);
        }
        return null;
    }

    private ReadWriteStream createStream(final PolicyScope scope, final ExecutionContext context, final PolicyChain policyChain) {
        return new BufferedReadWriteStream(){
            Buffer buffer = Buffer.buffer();

            public SimpleReadWriteStream<Buffer> write(Buffer content) {
                this.buffer.appendBuffer(content);
                return this;
            }

            public void end() {
                CalloutHttpPolicy.this.initRequestResponseProperties(context, scope == PolicyScope.REQUEST_CONTENT ? this.buffer.toString() : null, scope == PolicyScope.RESPONSE_CONTENT ? this.buffer.toString() : null);
                CalloutHttpPolicy.this.doCallout(context, result -> {
                    if (this.buffer.length() > 0) {
                        super.write((Object)this.buffer);
                    }
                    super.end();
                }, arg_0 -> ((PolicyChain)policyChain).streamFailWith(arg_0));
            }
        };
    }

    private void doCallout(ExecutionContext context, Consumer<Void> onSuccess, Consumer<PolicyResult> onError) {
        Vertx vertx = (Vertx)context.getComponent(Vertx.class);
        try {
            String url = context.getTemplateEngine().convert(this.configuration.getUrl());
            URI target = URI.create(url);
            HttpClientOptions options = new HttpClientOptions();
            if (HTTPS_SCHEME.equalsIgnoreCase(target.getScheme())) {
                options.setSsl(true).setTrustAll(true).setVerifyHost(false);
            }
            if (this.configuration.isUseSystemProxy()) {
                Environment env = (Environment)context.getComponent(Environment.class);
                options.setProxyOptions(this.getSystemProxyOptions(env));
            }
            HttpClient httpClient = vertx.createHttpClient(options);
            RequestOptions requestOpts = new RequestOptions().setAbsoluteURI(url).setMethod(this.convert(this.configuration.getMethod()));
            Future futureRequest = httpClient.request(requestOpts);
            futureRequest.onFailure(throwable -> this.handleFailure(onSuccess, onError, httpClient, (Throwable)throwable));
            futureRequest.onSuccess(httpClientRequest -> {
                Future futureResponse;
                if (this.configuration.getHeaders() != null) {
                    this.configuration.getHeaders().forEach(header -> {
                        try {
                            String extValue;
                            String string = extValue = header.getValue() != null ? context.getTemplateEngine().convert(header.getValue()) : null;
                            if (extValue != null) {
                                httpClientRequest.putHeader(header.getName(), extValue);
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    });
                }
                if (this.configuration.getBody() != null && !this.configuration.getBody().isEmpty()) {
                    String body = (String)context.getTemplateEngine().getValue(this.configuration.getBody(), String.class);
                    httpClientRequest.headers().remove(HttpHeaders.TRANSFER_ENCODING);
                    httpClientRequest.putHeader(HttpHeaders.CONTENT_LENGTH, (CharSequence)Integer.toString(body.length()));
                    futureResponse = httpClientRequest.send(io.vertx.core.buffer.Buffer.buffer((String)body));
                } else {
                    futureResponse = httpClientRequest.send();
                }
                futureResponse.onSuccess(httpResponse -> this.handleSuccess(context, onSuccess, onError, httpClient, (HttpClientResponse)httpResponse)).onFailure(throwable -> this.handleFailure(onSuccess, onError, httpClient, (Throwable)throwable));
            });
        }
        catch (Exception ex) {
            onError.accept(PolicyResult.failure((String)CALLOUT_HTTP_ERROR, (String)"Unable to apply expression language on the configured URL"));
        }
    }

    private void handleSuccess(ExecutionContext context, Consumer<Void> onSuccess, Consumer<PolicyResult> onError, HttpClient httpClient, HttpClientResponse httpResponse) {
        httpResponse.bodyHandler(body -> {
            TemplateEngine tplEngine = context.getTemplateEngine();
            tplEngine.getTemplateContext().setVariable(TEMPLATE_VARIABLE, (Object)new CalloutResponse(httpResponse, body.toString()));
            httpClient.close();
            boolean exit = false;
            if (this.configuration.isExitOnError()) {
                try {
                    exit = (Boolean)tplEngine.getValue(this.configuration.getErrorCondition(), Boolean.class);
                }
                catch (Exception ex) {
                    LOGGER.warn("Expression '{}' for Error Condition throws an exception, consider error condition as true. (cause: {})", (Object)this.configuration.getErrorCondition(), (Object)ex.getMessage());
                    exit = true;
                }
            }
            if (!exit) {
                if (this.configuration.getVariables() != null) {
                    this.configuration.getVariables().forEach(variable -> {
                        try {
                            String extValue = variable.getValue() != null ? (String)tplEngine.getValue(variable.getValue(), String.class) : null;
                            context.setAttribute(variable.getName(), (Object)extValue);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    });
                }
                tplEngine.getTemplateContext().setVariable(TEMPLATE_VARIABLE, null);
                onSuccess.accept(null);
            } else {
                String errorContent = this.configuration.getErrorContent();
                try {
                    errorContent = (String)tplEngine.getValue(this.configuration.getErrorContent(), String.class);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (errorContent == null || errorContent.isEmpty()) {
                    errorContent = "Request is terminated.";
                }
                onError.accept(PolicyResult.failure((String)CALLOUT_EXIT_ON_ERROR, (int)this.configuration.getErrorStatusCode(), (String)errorContent));
            }
        });
    }

    private void handleFailure(Consumer<Void> onSuccess, Consumer<PolicyResult> onError, HttpClient httpClient, Throwable throwable) {
        if (this.configuration.isExitOnError()) {
            onError.accept(PolicyResult.failure((String)CALLOUT_HTTP_ERROR, (String)throwable.getMessage()));
        } else {
            onSuccess.accept(null);
        }
        httpClient.close();
    }

    private ProxyOptions getSystemProxyOptions(Environment environment) {
        StringBuilder errors = new StringBuilder();
        ProxyOptions proxyOptions = new ProxyOptions();
        if (environment.containsProperty("system.proxy.host")) {
            proxyOptions.setHost(environment.getProperty("system.proxy.host"));
        } else {
            errors.append("'system.proxy.host' ");
        }
        try {
            proxyOptions.setPort(Integer.parseInt(Objects.requireNonNull(environment.getProperty("system.proxy.port"))));
        }
        catch (Exception e) {
            errors.append("'system.proxy.port' [").append(environment.getProperty("system.proxy.port")).append("] ");
        }
        try {
            proxyOptions.setType(ProxyType.valueOf((String)environment.getProperty("system.proxy.type")));
        }
        catch (Exception e) {
            errors.append("'system.proxy.type' [").append(environment.getProperty("system.proxy.type")).append("] ");
        }
        proxyOptions.setUsername(environment.getProperty("system.proxy.username"));
        proxyOptions.setPassword(environment.getProperty("system.proxy.password"));
        if (errors.length() == 0) {
            return proxyOptions;
        }
        LOGGER.warn("CalloutHttp requires a system proxy to be defined but some configurations are missing or not well defined: {}. Ignoring proxy", (Object)errors);
        return null;
    }

    private io.vertx.core.http.HttpMethod convert(HttpMethod httpMethod) {
        switch (httpMethod) {
            case CONNECT: {
                return io.vertx.core.http.HttpMethod.CONNECT;
            }
            case DELETE: {
                return io.vertx.core.http.HttpMethod.DELETE;
            }
            case GET: {
                return io.vertx.core.http.HttpMethod.GET;
            }
            case HEAD: {
                return io.vertx.core.http.HttpMethod.HEAD;
            }
            case OPTIONS: {
                return io.vertx.core.http.HttpMethod.OPTIONS;
            }
            case PATCH: {
                return io.vertx.core.http.HttpMethod.PATCH;
            }
            case POST: {
                return io.vertx.core.http.HttpMethod.POST;
            }
            case PUT: {
                return io.vertx.core.http.HttpMethod.PUT;
            }
            case TRACE: {
                return io.vertx.core.http.HttpMethod.TRACE;
            }
            case OTHER: {
                return io.vertx.core.http.HttpMethod.valueOf((String)"OTHER");
            }
        }
        return null;
    }
}

