/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.policy.groovy.sandbox;

import io.gravitee.policy.groovy.sandbox.SecuredResolver;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassCodeVisitorSupport;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.classgen.GeneratorContext;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.CompilePhase;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.control.customizers.CompilationCustomizer;

public class SecuredAnnotationCustomizer
extends CompilationCustomizer {
    public SecuredAnnotationCustomizer() {
        super(CompilePhase.CONVERSION);
    }

    public void call(SourceUnit source, GeneratorContext context, ClassNode classNode) throws CompilationFailedException {
        new RejectAnnotationVisitor(source).visitClass(classNode);
    }

    private static class RejectAnnotationVisitor
    extends ClassCodeVisitorSupport {
        private SourceUnit source;

        public RejectAnnotationVisitor(SourceUnit source) {
            this.source = source;
        }

        protected SourceUnit getSourceUnit() {
            return this.source;
        }

        public void visitAnnotations(AnnotatedNode node) {
            for (AnnotationNode an : node.getAnnotations()) {
                if (SecuredResolver.getInstance().isAnnotationAllowed(an.getClassNode().getName())) continue;
                throw new SecurityException("Annotation " + an.getClassNode().getName() + " cannot be used in the sandbox.");
            }
        }
    }
}

