/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.policy.groovy.sandbox;

import groovy.lang.Binding;
import groovy.lang.GroovyCodeSource;
import groovy.lang.GroovyShell;
import groovy.lang.Script;
import io.gravitee.policy.groovy.GroovyPolicy;
import io.gravitee.policy.groovy.sandbox.SecuredAnnotationCustomizer;
import io.gravitee.policy.groovy.sandbox.SecuredInterceptor;
import io.gravitee.policy.groovy.utils.Sha1;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.groovy.json.internal.FastStringUtils;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.customizers.CompilationCustomizer;
import org.codehaus.groovy.control.customizers.SecureASTCustomizer;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.kohsuke.groovy.sandbox.GroovyInterceptor;
import org.kohsuke.groovy.sandbox.SandboxTransformer;

public class SecuredGroovyShell {
    private GroovyShell groovyShell;
    private ConcurrentMap<String, Class<?>> sources = new ConcurrentHashMap();
    private GroovyInterceptor groovyInterceptor;

    public SecuredGroovyShell() {
        CompilerConfiguration conf = new CompilerConfiguration();
        conf.addCompilationCustomizers(new CompilationCustomizer[]{new SandboxTransformer()});
        conf.addCompilationCustomizers(new CompilationCustomizer[]{new SecuredAnnotationCustomizer()});
        SecureASTCustomizer secureASTCustomizer = new SecureASTCustomizer();
        secureASTCustomizer.setPackageAllowed(false);
        conf.addCompilationCustomizers(new CompilationCustomizer[]{secureASTCustomizer});
        this.groovyShell = new GroovyShell(conf);
        this.groovyInterceptor = new SecuredInterceptor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T evaluate(String script, Binding binding) {
        try {
            this.groovyInterceptor.register();
            Class<?> scriptClass = this.getOrCreate(script);
            Script gScript = InvokerHelper.createScript(scriptClass, (Binding)binding);
            Object object = gScript.run();
            return (T)object;
        }
        finally {
            this.groovyInterceptor.unregister();
        }
    }

    private Class<?> getOrCreate(String script) throws CompilationFailedException {
        String key = Sha1.sha1(script);
        return this.sources.computeIfAbsent(key, s -> {
            GroovyCodeSource gcs = new GroovyCodeSource(script, key, "/groovy/shell");
            return this.groovyShell.getClassLoader().parseClass(gcs, true);
        });
    }

    static {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(GroovyPolicy.class.getClassLoader());
        FastStringUtils.toCharArray((String)"hack");
        Thread.currentThread().setContextClassLoader(loader);
    }
}

