/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.policy.groovy.sandbox;

import groovy.lang.Script;
import io.gravitee.common.util.MultiValueMap;
import io.gravitee.policy.groovy.sandbox.SecuredResolver;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.kohsuke.groovy.sandbox.GroovyInterceptor;

public class SecuredInterceptor
extends GroovyInterceptor {
    public Object onMethodCall(GroovyInterceptor.Invoker invoker, Object receiver, String method, Object ... args) throws Throwable {
        if (receiver instanceof MultiValueMap && method.equals("put") && args.length == 2 && SecuredResolver.getInstance().isMethodAllowed(receiver, "set", args)) {
            return super.onMethodCall(invoker, receiver, "set", args);
        }
        if (SecuredResolver.getInstance().isMethodAllowed(receiver, method, args)) {
            return super.onMethodCall(invoker, receiver, method, args);
        }
        throw new SecurityException("Failed to resolve method [ " + this.prettyPrint(receiver, method, args) + " ]");
    }

    public Object onStaticCall(GroovyInterceptor.Invoker invoker, Class receiver, String method, Object ... args) throws Throwable {
        if (SecuredResolver.getInstance().isMethodAllowed((Object)receiver, method, args)) {
            return super.onStaticCall(invoker, receiver, method, args);
        }
        throw new SecurityException("Failed to resolve method [ " + this.prettyPrint(receiver, method, args) + " ]");
    }

    public Object onNewInstance(GroovyInterceptor.Invoker invoker, Class receiver, Object ... args) throws Throwable {
        if (SecuredResolver.getInstance().isConstructorAllowed(receiver, args)) {
            return super.onNewInstance(invoker, receiver, args);
        }
        throw new SecurityException("Failed to resolve constructor [" + this.prettyPrint(receiver, "<init>", args) + "]");
    }

    public Object onSuperCall(GroovyInterceptor.Invoker invoker, Class senderType, Object receiver, String method, Object ... args) throws Throwable {
        if (SecuredResolver.getInstance().isMethodAllowed(receiver, method, args)) {
            return super.onSuperCall(invoker, senderType, receiver, method, args);
        }
        throw new SecurityException("Failed to resolve method [ " + this.prettyPrint(receiver, method, args) + " ]");
    }

    public void onSuperConstructor(GroovyInterceptor.Invoker invoker, Class receiver, Object ... args) throws Throwable {
        if (!SecuredResolver.getInstance().isConstructorAllowed(receiver, args)) {
            throw new SecurityException("Failed to resolve constructor [" + this.prettyPrint(receiver, "<init>", args) + "]");
        }
        super.onSuperConstructor(invoker, receiver, args);
    }

    public Object onGetProperty(GroovyInterceptor.Invoker invoker, Object receiver, String property) throws Throwable {
        if (receiver instanceof Script && !property.equals("binding") && !property.equals("metaClass")) {
            return super.onGetProperty(invoker, receiver, property);
        }
        if (SecuredResolver.getInstance().isGetPropertyAllowed(receiver, property)) {
            return super.onGetProperty(invoker, receiver, property);
        }
        throw new SecurityException("Failed to resolve getter method or field [" + this.prettyPrint(receiver, property, new Object[0]) + "]");
    }

    public Object onSetProperty(GroovyInterceptor.Invoker invoker, Object receiver, String property, Object value) throws Throwable {
        if (receiver instanceof Script && !property.equals("binding") && !property.equals("metaClass")) {
            return super.onSetProperty(invoker, receiver, property, value);
        }
        if (SecuredResolver.getInstance().isSetPropertyAllowed(receiver, property, value)) {
            return super.onSetProperty(invoker, receiver, property, value);
        }
        throw new SecurityException("Failed to resolve setter method or field [" + this.prettyPrint(receiver, property, value) + "]");
    }

    public Object onGetAttribute(GroovyInterceptor.Invoker invoker, Object receiver, String attribute) throws Throwable {
        if (SecuredResolver.getInstance().isGetPropertyAllowed(receiver, attribute)) {
            return super.onGetAttribute(invoker, receiver, attribute);
        }
        throw new SecurityException("Failed to get field [" + this.prettyPrint(receiver, attribute, new Object[0]) + "]");
    }

    public Object onSetAttribute(GroovyInterceptor.Invoker invoker, Object receiver, String attribute, Object value) throws Throwable {
        if (SecuredResolver.getInstance().isSetPropertyAllowed(receiver, attribute, value)) {
            return super.onSetAttribute(invoker, receiver, attribute, value);
        }
        throw new SecurityException("Failed to set field [" + this.prettyPrint(receiver, attribute, value) + "]");
    }

    public Object onGetArray(GroovyInterceptor.Invoker invoker, Object receiver, Object index) throws Throwable {
        if (this.isArrayAccess(receiver, index)) {
            return super.onGetArray(invoker, receiver, index);
        }
        return this.onMethodCall(invoker, receiver, "getAt", index);
    }

    public Object onSetArray(GroovyInterceptor.Invoker invoker, Object receiver, Object index, Object value) throws Throwable {
        if (this.isArrayAccess(receiver, index)) {
            return super.onSetArray(invoker, receiver, index, value);
        }
        return this.onMethodCall(invoker, receiver, "putAt", index, value);
    }

    private String prettyPrint(Object receiver, String method, Object ... args) {
        return (receiver instanceof Class ? receiver : receiver.getClass()) + " " + method + " " + Arrays.asList(args).stream().map(arg -> arg == null ? Object.class.getCanonicalName() : arg.getClass().getCanonicalName()).collect(Collectors.joining(" "));
    }

    private boolean isArrayAccess(Object receiver, Object index) {
        return (receiver.getClass().isArray() || List.class.isAssignableFrom(receiver.getClass())) && index instanceof Integer;
    }
}

