/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.policy.groovy.sandbox;

import groovy.lang.GString;
import groovy.lang.GroovyClassLoader;
import groovy.lang.Script;
import io.gravitee.common.util.EnvironmentUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.ConstructorUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.codehaus.groovy.runtime.DateGroovyMethods;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.EncodingGroovyMethods;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.lang.Nullable;
import org.springframework.util.ClassUtils;

public class SecuredResolver {
    private static final Logger logger = LoggerFactory.getLogger(SecuredResolver.class);
    static final String WHITELIST_MODE = "append";
    static final String WHITELIST_MODE_KEY = "groovy.whitelist.mode";
    static final String WHITELIST_LIST_KEY = "groovy.whitelist.list";
    static final String WHITELIST_METHOD_PREFIX = "method ";
    static final String WHITELIST_FIELD_PREFIX = "field ";
    static final String WHITELIST_CLASS_PREFIX = "class ";
    static final String WHITELIST_CONSTRUCTOR_PREFIX = "new ";
    static final String WHITELIST_ANNOTATION_PREFIX = "annotation ";
    private static final Set<String> NUMBER_MATH_METHOD_NAMES = new HashSet<String>(Arrays.asList("plus", "minus", "multiply", "div", "compareTo", "or", "and", "xor", "intdiv", "mod", "leftShift", "rightShift", "rightShiftUnsigned"));
    private static final Class<?>[] DGM_CLASSES = new Class[]{DefaultGroovyMethods.class, StringGroovyMethods.class, EncodingGroovyMethods.class, DateGroovyMethods.class};
    private static final List<String> ALLOWED_ARRAY_NATIVE_METHODS = Arrays.asList("getAt", "putAt", "getLength");
    private static SecuredResolver INSTANCE;
    private static Map<Class<?>, List<Method>> methodsByType;
    private static Map<Class<?>, List<Field>> fieldsByType;
    private static Map<Class<?>, List<Constructor<?>>> constructorsByType;
    private static Set<Class<?>> annotations;
    private final Map<Class<?>, List<Method>> methodsByTypeAndSuperTypes;
    private final Map<String, Boolean> resolved = new ConcurrentHashMap<String, Boolean>();

    public static void initialize(@Nullable Environment environment) {
        SecuredResolver.loadWhitelist(environment);
        INSTANCE = new SecuredResolver();
    }

    public static void destroy() {
        if (INSTANCE != null) {
            methodsByType.clear();
            fieldsByType.clear();
            constructorsByType.clear();
            annotations.clear();
            INSTANCE = null;
        }
    }

    public static SecuredResolver getInstance() {
        if (INSTANCE == null) {
            SecuredResolver.initialize(null);
        }
        return INSTANCE;
    }

    private SecuredResolver() {
        this.methodsByTypeAndSuperTypes = new ConcurrentHashMap();
    }

    public boolean isAnnotationAllowed(String name) {
        return annotations.stream().anyMatch(aClass -> aClass.getCanonicalName().equals(name) || aClass.getName().equals(name) || aClass.getSimpleName().equals(name) || aClass.getTypeName().equals(name));
    }

    public boolean isConstructorAllowed(Class<?> clazz, Object ... constructorArgs) {
        String key = this.getKey(clazz, "<init>", constructorArgs);
        if (this.resolved.containsKey(key)) {
            return this.resolved.get(key);
        }
        if (this.isGroovyScriptDefinedClass(clazz)) {
            this.resolved.put(key, true);
            return true;
        }
        Class[] argumentClasses = this.getClasses(constructorArgs);
        Constructor constructor = ConstructorUtils.getMatchingAccessibleConstructor(clazz, (Class[])argumentClasses);
        boolean constructorAllowed = constructorsByType.getOrDefault(clazz, Collections.emptyList()).contains(constructor);
        this.resolved.put(key, constructorAllowed);
        return constructorAllowed;
    }

    public boolean isGetPropertyAllowed(Object object, String propertyName) {
        String[] getPrefixes;
        Class<?> objectClass = object instanceof Class ? (Class<?>)object : object.getClass();
        String key = this.getKey(object, propertyName, new Object[0]);
        if (this.resolved.containsKey(key)) {
            return this.resolved.get(key);
        }
        if (this.isGroovyScriptDefinedClass(objectClass)) {
            this.resolved.put(key, true);
            return true;
        }
        for (String prefix : getPrefixes = new String[]{"get", "is"}) {
            String getter = prefix + StringUtils.capitalize((String)propertyName);
            if (!this.isMethodAllowed(object, getter, new Object[0])) continue;
            this.resolved.put(key, true);
            return true;
        }
        Field field = FieldUtils.getDeclaredField(objectClass, (String)propertyName);
        if (field != null && this.getAllowedFields(objectClass).contains(field)) {
            this.resolved.put(key, true);
            return true;
        }
        return false;
    }

    public boolean isSetPropertyAllowed(Object object, String propertyName, Object propertyValue) {
        Class<?> objectClass = object instanceof Class ? (Class<?>)object : object.getClass();
        String key = this.getKey(object, propertyName, new Object[0]);
        if (this.resolved.containsKey(key)) {
            return this.resolved.get(key);
        }
        if (this.isGroovyScriptDefinedClass(objectClass)) {
            this.resolved.put(key, true);
            return true;
        }
        String getter = "set" + StringUtils.capitalize((String)propertyName);
        if (this.isMethodAllowed(object, getter, propertyValue)) {
            this.resolved.put(key, true);
            return true;
        }
        Field field = FieldUtils.getDeclaredField(objectClass, (String)propertyName);
        if (field != null && this.getAllowedFields(objectClass).contains(field)) {
            this.resolved.put(key, true);
            return true;
        }
        return false;
    }

    public boolean isMethodAllowed(Object object, String methodName, Object ... methodArgs) {
        Class<?> objectClass = object instanceof Class ? (Class<?>)object : object.getClass();
        String key = this.getKey(objectClass, methodName, methodArgs);
        if (this.resolved.containsKey(key)) {
            return this.resolved.get(key);
        }
        if (object instanceof Number && NUMBER_MATH_METHOD_NAMES.contains(methodName)) {
            this.resolved.put(key, true);
            return true;
        }
        Class<?>[] argumentClasses = this.getClasses(methodArgs);
        boolean methodAllowed = this.isMethodAllowed(objectClass, methodName, argumentClasses) || this.isDGMAllowed(objectClass, methodName, argumentClasses);
        this.resolved.put(key, methodAllowed);
        return methodAllowed;
    }

    private boolean isMethodAllowed(Class<?> clazz, String methodName, Class<?>[] argumentClasses) {
        Class[] interfaces;
        if (clazz == null) {
            return false;
        }
        Method method = MethodUtils.getMatchingAccessibleMethod(clazz, (String)methodName, (Class[])argumentClasses);
        if (method != null && (this.isGroovyScriptDefinedMethod(method) || this.getAllowedMethods(clazz).contains(method))) {
            return true;
        }
        if (this.isMethodAllowed(clazz.getSuperclass(), methodName, argumentClasses)) {
            return true;
        }
        for (Class c : interfaces = ClassUtils.getAllInterfacesForClass(clazz)) {
            if (c == clazz || !this.isMethodAllowed(c, methodName, argumentClasses)) continue;
            return true;
        }
        return false;
    }

    private boolean isDGMAllowed(Class<?> clazz, String methodName, Class<?>[] argumentClasses) {
        Class[] selfArgs = new Class[argumentClasses.length + 1];
        selfArgs[0] = clazz;
        System.arraycopy(argumentClasses, 0, selfArgs, 1, argumentClasses.length);
        if (clazz.isArray() && ALLOWED_ARRAY_NATIVE_METHODS.contains(methodName)) {
            return true;
        }
        for (Class<?> dgmClass : DGM_CLASSES) {
            Method method = MethodUtils.getMatchingAccessibleMethod(dgmClass, (String)methodName, (Class[])selfArgs);
            if (method == null || !this.getAllowedMethods(dgmClass).contains(method)) continue;
            return true;
        }
        return false;
    }

    private boolean isGroovyScriptDefinedClass(Class<?> clazz) {
        return clazz.getClassLoader() instanceof GroovyClassLoader && !Script.class.isAssignableFrom(clazz);
    }

    private boolean isGroovyScriptDefinedMethod(Method method) {
        Class<?> clazz = method.getDeclaringClass();
        return clazz.getClassLoader() instanceof GroovyClassLoader && clazz != Script.class;
    }

    private List<Method> getAllowedMethods(Class<?> clazz) {
        if (this.methodsByTypeAndSuperTypes.containsKey(clazz)) {
            return this.methodsByTypeAndSuperTypes.get(clazz);
        }
        List<Method> methods = methodsByType.getOrDefault(clazz, Collections.emptyList());
        if (clazz.getSuperclass() != null) {
            methods = Stream.concat(methods.stream(), this.getAllowedMethods(clazz.getSuperclass()).stream()).collect(Collectors.toList());
        }
        for (Class<?> anInterface : clazz.getInterfaces()) {
            methods = Stream.concat(methods.stream(), this.getAllowedMethods(anInterface).stream()).collect(Collectors.toList());
        }
        this.methodsByTypeAndSuperTypes.put(clazz, methods);
        return methods;
    }

    private List<Field> getAllowedFields(Class<?> clazz) {
        return fieldsByType.getOrDefault(clazz, Collections.emptyList());
    }

    private String getKey(Object object, String methodName, Object[] methodArgs) {
        Object[] argumentClasses = this.getClasses(methodArgs);
        return (object instanceof Class ? object : object.getClass()) + "#" + methodName + Arrays.toString(argumentClasses);
    }

    private Class<?>[] getClasses(Object[] objects) {
        Class[] argumentClasses = new Class[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            argumentClasses[i] = objects[i] instanceof GString ? String.class : (objects[i] != null ? objects[i].getClass() : Object.class);
        }
        return argumentClasses;
    }

    private static void loadWhitelist(Environment environment) {
        ArrayList<Method> methods = new ArrayList<Method>();
        ArrayList<Field> fields = new ArrayList<Field>();
        ArrayList constructors = new ArrayList();
        ArrayList annotationClasses = new ArrayList();
        boolean loadBuiltInWhitelist = true;
        if (environment != null) {
            loadBuiltInWhitelist = WHITELIST_MODE.equals(environment.getProperty(WHITELIST_MODE_KEY, WHITELIST_MODE));
            Collection configWhitelist = EnvironmentUtils.getPropertiesStartingWith((ConfigurableEnvironment)((ConfigurableEnvironment)environment), (String)WHITELIST_LIST_KEY).values();
            for (String declaration : configWhitelist) {
                SecuredResolver.parseDeclaration(String.valueOf(declaration), methods, fields, constructors, annotationClasses);
            }
        }
        if (loadBuiltInWhitelist) {
            InputStream input = SecuredResolver.class.getResourceAsStream("/groovy-whitelist");
            BufferedReader reader = new BufferedReader(new InputStreamReader(input));
            try {
                String declaration;
                while ((declaration = reader.readLine()) != null) {
                    SecuredResolver.parseDeclaration(declaration, methods, fields, constructors, annotationClasses);
                }
            }
            catch (IOException ioe) {
                logger.error("Unable to read Groovy built-in groovy-whitelist", (Throwable)ioe);
            }
        }
        methodsByType = methods.stream().collect(Collectors.groupingBy(Method::getDeclaringClass));
        fieldsByType = fields.stream().collect(Collectors.groupingBy(Field::getDeclaringClass));
        constructorsByType = constructors.stream().collect(Collectors.groupingBy(Constructor::getDeclaringClass));
        annotations = new HashSet(annotationClasses);
    }

    private static void parseDeclaration(String declaration, List<Method> methods, List<Field> fields, List<Constructor<?>> constructors, List<Class<?>> annotations) {
        try {
            if (declaration.startsWith(WHITELIST_METHOD_PREFIX)) {
                methods.add(SecuredResolver.parseMethod(declaration));
            } else if (declaration.startsWith(WHITELIST_FIELD_PREFIX)) {
                fields.add(SecuredResolver.parseField(declaration));
            } else if (declaration.startsWith(WHITELIST_CONSTRUCTOR_PREFIX)) {
                constructors.add(SecuredResolver.parseConstructor(declaration));
            } else if (declaration.startsWith(WHITELIST_ANNOTATION_PREFIX)) {
                annotations.add(SecuredResolver.parseAnnotation(declaration));
            } else if (declaration.startsWith(WHITELIST_CLASS_PREFIX)) {
                methods.addAll(SecuredResolver.parseAllMethods(declaration));
                fields.addAll(SecuredResolver.parseAllFields(declaration));
                constructors.addAll(SecuredResolver.parseAllConstructors(declaration));
            }
        }
        catch (Exception e) {
            logger.warn("The Groovy whitelisted declaration [{}] cannot be loaded. Message is [{}]", (Object)declaration, (Object)e.toString());
        }
    }

    private static Method parseMethod(String declaration) throws Exception {
        String[] split = declaration.split(" ");
        String clazzName = split[1];
        String methodName = split[2];
        String[] methodArgs = new String[]{};
        if (split.length > 3) {
            methodArgs = Arrays.copyOfRange(split, 3, split.length);
        }
        Class[] argumentClasses = new Class[methodArgs.length];
        for (int i = 0; i < methodArgs.length; ++i) {
            argumentClasses[i] = ClassUtils.forName((String)methodArgs[i], (ClassLoader)SecuredResolver.class.getClassLoader());
        }
        Class clazz = ClassUtils.forName((String)clazzName, (ClassLoader)SecuredResolver.class.getClassLoader());
        return clazz.getDeclaredMethod(methodName, argumentClasses);
    }

    private static List<Method> parseAllMethods(String declaration) throws Exception {
        String[] split = declaration.split(" ");
        String clazzName = split[1];
        Class clazz = ClassUtils.forName((String)clazzName, (ClassLoader)SecuredResolver.class.getClassLoader());
        return Arrays.asList(clazz.getDeclaredMethods());
    }

    private static Field parseField(String declaration) throws Exception {
        String[] split = declaration.split(" ");
        String clazzName = split[1];
        String fieldName = split[2];
        Class clazz = ClassUtils.forName((String)clazzName, (ClassLoader)SecuredResolver.class.getClassLoader());
        return clazz.getDeclaredField(fieldName);
    }

    private static List<Field> parseAllFields(String declaration) throws Exception {
        String[] split = declaration.split(" ");
        String clazzName = split[1];
        Class clazz = ClassUtils.forName((String)clazzName, (ClassLoader)SecuredResolver.class.getClassLoader());
        return Arrays.asList(clazz.getDeclaredFields());
    }

    private static Constructor parseConstructor(String declaration) throws Exception {
        String[] split = declaration.split(" ");
        String clazzName = split[1];
        String[] methodArgs = new String[]{};
        if (split.length > 2) {
            methodArgs = Arrays.copyOfRange(split, 2, split.length);
        }
        Class[] argumentClasses = new Class[methodArgs.length];
        for (int i = 0; i < methodArgs.length; ++i) {
            argumentClasses[i] = ClassUtils.forName((String)methodArgs[i], (ClassLoader)SecuredResolver.class.getClassLoader());
        }
        Class clazz = ClassUtils.forName((String)clazzName, (ClassLoader)SecuredResolver.class.getClassLoader());
        return clazz.getDeclaredConstructor(argumentClasses);
    }

    private static List<Constructor<?>> parseAllConstructors(String declaration) throws Exception {
        String[] split = declaration.split(" ");
        String clazzName = split[1];
        Class clazz = ClassUtils.forName((String)clazzName, (ClassLoader)SecuredResolver.class.getClassLoader());
        return Arrays.asList(clazz.getDeclaredConstructors());
    }

    private static Class<?> parseAnnotation(String declaration) throws Exception {
        String[] split = declaration.split(" ");
        String clazzName = split[1];
        return ClassUtils.forName((String)clazzName, (ClassLoader)SecuredResolver.class.getClassLoader());
    }
}

