/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.policy.html2Json;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.gravitee.gateway.api.Response;
import io.gravitee.gateway.api.buffer.Buffer;
import io.gravitee.gateway.api.http.stream.TransformableResponseStreamBuilder;
import io.gravitee.gateway.api.stream.ReadWriteStream;
import io.gravitee.policy.api.annotations.OnResponseContent;
import io.gravitee.policy.html2Json.HTMLToJSONTransformationPolicyConfiguration;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class HTMLToJSONTransformationPolicy {
    private static final String APPLICATION_JSON = "application/json; charset=UTF-8";
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final HTMLToJSONTransformationPolicyConfiguration htmlToJSONTransformationPolicyConfiguration;

    public HTMLToJSONTransformationPolicy(HTMLToJSONTransformationPolicyConfiguration htmlToJSONTransformationPolicyConfiguration) {
        this.htmlToJSONTransformationPolicyConfiguration = htmlToJSONTransformationPolicyConfiguration;
    }

    @OnResponseContent
    public ReadWriteStream onResponseContent(Response response) {
        return TransformableResponseStreamBuilder.on((Response)response).contentType(APPLICATION_JSON).transform(input -> {
            HashMap<String, Object> jsonContent = new HashMap<String, Object>();
            Document document = Jsoup.parse((String)input.toString());
            for (HTMLToJSONTransformationPolicyConfiguration.Selector selector : this.htmlToJSONTransformationPolicyConfiguration.getSelectors()) {
                if (selector.isArray()) {
                    Elements selectedElement = document.select(selector.getSelector());
                    List elements = selectedElement.stream().map(Element::text).collect(Collectors.toList());
                    jsonContent.put(selector.getJsonName(), elements);
                    continue;
                }
                jsonContent.put(selector.getJsonName(), document.select(selector.getSelector()).text());
            }
            try {
                return Buffer.buffer((String)this.objectMapper.writeValueAsString(jsonContent));
            }
            catch (JsonProcessingException ex) {
                throw new IllegalStateException("Unable to transform into JSON: " + ex.getMessage(), ex);
            }
        }).build();
    }
}

