/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.policy.httpsignature;

import io.gravitee.gateway.api.ExecutionContext;
import io.gravitee.gateway.api.Request;
import io.gravitee.gateway.api.Response;
import io.gravitee.gateway.api.http.HttpHeaders;
import io.gravitee.policy.api.PolicyChain;
import io.gravitee.policy.api.PolicyResult;
import io.gravitee.policy.api.annotations.OnRequest;
import io.gravitee.policy.httpsignature.configuration.HttpSignaturePolicyConfiguration;
import io.gravitee.policy.httpsignature.configuration.HttpSignatureScheme;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.crypto.spec.SecretKeySpec;
import org.tomitribe.auth.signatures.Signature;
import org.tomitribe.auth.signatures.Signer;

public class HttpSignaturePolicy {
    private static final String HTTP_SIGNATURE_INVALID_SIGNATURE = "HTTP_SIGNATURE_INVALID_SIGNATURE";
    static final String HTTP_HEADER_SIGNATURE = "Signature";
    private final HttpSignaturePolicyConfiguration configuration;
    private static final Pattern RFC_2617_PARAM_NON_STRICT = Pattern.compile("(?<key>\\w+)=((?<stringValue>.*?)($|,))");

    public HttpSignaturePolicy(HttpSignaturePolicyConfiguration configuration) {
        this.configuration = configuration;
    }

    @OnRequest
    public void onRequest(Request request, Response response, ExecutionContext context, PolicyChain chain) {
        Signature signature = this.extractSignature(request);
        if (!(signature != null && this.enforceAlgorithm(signature) && this.enforceHeaders(signature) && this.validateHeaders(signature, request) && this.verifySignatureValidityDates(signature) && this.verifySignature(signature, context, request))) {
            chain.failWith(PolicyResult.failure((String)HTTP_SIGNATURE_INVALID_SIGNATURE, (int)401, (String)"Invalid HTTP Signature"));
            return;
        }
        chain.doNext(request, response);
    }

    private boolean verifySignature(Signature reqSignature, ExecutionContext context, Request request) {
        try {
            Long maxSignatureValidationDuration = null;
            if (reqSignature.getSignatureCreationTimeMilliseconds() != null && reqSignature.getSignatureExpirationTimeMilliseconds() != null) {
                maxSignatureValidationDuration = reqSignature.getSignatureExpirationTimeMilliseconds() - reqSignature.getSignatureCreationTimeMilliseconds();
            }
            Signature signature = new Signature(reqSignature.getKeyId(), reqSignature.getSigningAlgorithm(), reqSignature.getAlgorithm(), reqSignature.getParameterSpec(), null, reqSignature.getHeaders(), maxSignatureValidationDuration, reqSignature.getSignatureCreationTimeMilliseconds(), reqSignature.getSignatureExpirationTimeMilliseconds());
            context.getTemplateEngine().getTemplateContext().setVariable("keyId", (Object)reqSignature.getKeyId());
            String secret = (String)context.getTemplateEngine().getValue(this.configuration.getSecret(), String.class);
            SecretKeySpec key = new SecretKeySpec(secret.getBytes(), reqSignature.getAlgorithm().getJvmName());
            Signer signer = new Signer(key, signature);
            Signature signed = signer.sign(request.method().name().toLowerCase(), request.path(), request.headers().toSingleValueMap(), reqSignature.getSignatureCreationTimeMilliseconds(), reqSignature.getSignatureExpirationTimeMilliseconds());
            String sReqSignature = reqSignature.getSignature();
            if (this.configuration.isDecodeSignature()) {
                sReqSignature = URLDecoder.decode(sReqSignature, StandardCharsets.UTF_8.name());
            }
            return signed.getSignature().equals(sReqSignature);
        }
        catch (Exception ex) {
            return false;
        }
    }

    private boolean verifySignatureValidityDates(Signature signature) {
        if (this.configuration.getClockSkew() > 0L) {
            if (signature.getSignatureCreationTimeMilliseconds() != null && signature.getSignatureCreationTimeMilliseconds() > System.currentTimeMillis() + this.configuration.getClockSkew() * 1000L) {
                return false;
            }
            if (signature.getSignatureExpirationTimeMilliseconds() != null && signature.getSignatureExpirationTimeMilliseconds() < System.currentTimeMillis()) {
                return false;
            }
        }
        return true;
    }

    private boolean enforceHeaders(Signature signature) {
        List<String> sigHeaders = signature.getHeaders();
        if (this.configuration.getEnforceHeaders() != null && !this.configuration.getEnforceHeaders().isEmpty()) {
            if (this.configuration.getEnforceHeaders().size() > sigHeaders.size()) {
                return false;
            }
            return this.configuration.getEnforceHeaders().stream().map(String::toLowerCase).filter(header -> !header.startsWith("(") && !header.endsWith(")")).allMatch(sigHeaders::contains);
        }
        return true;
    }

    private boolean validateHeaders(Signature signature, Request request) {
        List<String> sigHeaders = signature.getHeaders();
        return sigHeaders.stream().filter(header -> !header.startsWith("(") && !header.endsWith(")")).allMatch(arg_0 -> ((HttpHeaders)request.headers()).containsKey(arg_0));
    }

    private boolean enforceAlgorithm(Signature signature) {
        if (this.configuration.getAlgorithms() != null && !this.configuration.getAlgorithms().isEmpty()) {
            return this.configuration.getAlgorithms().stream().anyMatch(algorithm -> algorithm.getAlg() == signature.getAlgorithm());
        }
        return true;
    }

    private Signature extractSignature(Request request) {
        String signature = null;
        if (this.configuration.getScheme() == HttpSignatureScheme.AUTHORIZATION) {
            signature = request.headers().get((CharSequence)"Authorization");
        } else if (this.configuration.getScheme() == HttpSignatureScheme.SIGNATURE) {
            signature = request.headers().getFirst((CharSequence)HTTP_HEADER_SIGNATURE);
        }
        try {
            if (signature == null) {
                return null;
            }
            if (!this.configuration.isStrictMode() && !signature.contains("\"")) {
                signature = this.convertToStrictSignature(signature);
            }
            return Signature.fromString(signature);
        }
        catch (Exception ex) {
            request.metrics().setMessage(ex.getMessage());
            return null;
        }
    }

    private String convertToStrictSignature(String signature) {
        Matcher matcher = RFC_2617_PARAM_NON_STRICT.matcher(signature);
        HashMap<String, String> kv = new HashMap<String, String>();
        while (matcher.find()) {
            String key = matcher.group("key").toLowerCase();
            String value = matcher.group("stringValue");
            try {
                Long.parseLong(value);
                kv.put(key, value);
            }
            catch (NumberFormatException e) {
                kv.put(key, "\"" + value + "\"");
            }
        }
        String newSignature = "Signature " + kv.entrySet().stream().map(entry -> (String)entry.getKey() + "=" + (String)entry.getValue()).reduce((a, b) -> a + "," + b).get();
        return newSignature;
    }
}

