/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.policy.jsonvalidation;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jackson.JsonLoader;
import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.github.fge.jsonschema.main.JsonSchemaFactory;
import com.github.fge.jsonschema.main.JsonValidator;
import io.gravitee.gateway.api.ExecutionContext;
import io.gravitee.gateway.api.Request;
import io.gravitee.gateway.api.Response;
import io.gravitee.gateway.api.buffer.Buffer;
import io.gravitee.gateway.api.stream.BufferedReadWriteStream;
import io.gravitee.gateway.api.stream.ReadWriteStream;
import io.gravitee.gateway.api.stream.SimpleReadWriteStream;
import io.gravitee.policy.api.PolicyChain;
import io.gravitee.policy.api.PolicyResult;
import io.gravitee.policy.api.annotations.OnRequestContent;
import io.gravitee.policy.api.annotations.OnResponseContent;
import io.gravitee.policy.jsonvalidation.configuration.JsonValidationPolicyConfiguration;
import io.gravitee.policy.jsonvalidation.configuration.PolicyScope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonValidationPolicy {
    private static final Logger logger = LoggerFactory.getLogger(JsonValidationPolicy.class);
    static final String JSON_INVALID_PAYLOAD_KEY = "JSON_INVALID_PAYLOAD";
    static final String JSON_INVALID_FORMAT_KEY = "JSON_INVALID_FORMAT";
    static final String JSON_INVALID_RESPONSE_PAYLOAD_KEY = "JSON_INVALID_RESPONSE_PAYLOAD";
    static final String JSON_INVALID_RESPONSE_FORMAT_KEY = "JSON_INVALID_RESPONSE_FORMAT";
    private static final String BAD_REQUEST = "Bad Request";
    private static final String INTERNAL_ERROR = "Internal Error";
    private final JsonValidationPolicyConfiguration configuration;
    private static final JsonValidator validator = JsonSchemaFactory.byDefault().getValidator();

    public JsonValidationPolicy(JsonValidationPolicyConfiguration configuration) {
        this.configuration = configuration;
    }

    @OnRequestContent
    public ReadWriteStream onRequestContent(final Request request, Response response, final ExecutionContext executionContext, final PolicyChain policyChain) {
        if (this.configuration.getScope() == null || this.configuration.getScope() == PolicyScope.REQUEST_CONTENT) {
            logger.debug("Execute json schema validation policy on request content{}", (Object)request.id());
            return new BufferedReadWriteStream(){
                final Buffer buffer = Buffer.buffer();

                public SimpleReadWriteStream<Buffer> write(Buffer content) {
                    this.buffer.appendBuffer(content);
                    return this;
                }

                public void end() {
                    try {
                        JsonNode schema = JsonLoader.fromString((String)JsonValidationPolicy.this.configuration.getSchema());
                        JsonNode content = JsonLoader.fromString((String)this.buffer.toString());
                        ProcessingReport report = JsonValidationPolicy.this.getReport(schema, content);
                        if (!report.isSuccess()) {
                            request.metrics().setMessage(report.toString());
                            JsonValidationPolicy.this.sendErrorResponse(JsonValidationPolicy.JSON_INVALID_PAYLOAD_KEY, executionContext, policyChain, 400);
                        } else {
                            if (this.buffer.length() > 0) {
                                super.write((Object)this.buffer);
                            }
                            super.end();
                        }
                    }
                    catch (Exception ex) {
                        request.metrics().setMessage(ex.getMessage());
                        JsonValidationPolicy.this.sendErrorResponse(JsonValidationPolicy.JSON_INVALID_FORMAT_KEY, executionContext, policyChain, 400);
                    }
                }
            };
        }
        return null;
    }

    @OnResponseContent
    public ReadWriteStream onResponseContent(final Request request, Response response, final ExecutionContext executionContext, final PolicyChain policyChain) {
        if (this.configuration.getScope() == PolicyScope.RESPONSE_CONTENT) {
            logger.debug("Execute json schema validation policy on request content{}", (Object)request.id());
            return new BufferedReadWriteStream(){
                final Buffer buffer = Buffer.buffer();

                public SimpleReadWriteStream<Buffer> write(Buffer content) {
                    this.buffer.appendBuffer(content);
                    return this;
                }

                public void end() {
                    block6: {
                        try {
                            JsonNode schema = JsonLoader.fromString((String)JsonValidationPolicy.this.configuration.getSchema());
                            JsonNode content = JsonLoader.fromString((String)this.buffer.toString());
                            ProcessingReport report = JsonValidationPolicy.this.getReport(schema, content);
                            if (!report.isSuccess()) {
                                request.metrics().setMessage(report.toString());
                                if (!JsonValidationPolicy.this.configuration.isStraightRespondMode()) {
                                    JsonValidationPolicy.this.sendErrorResponse(JsonValidationPolicy.JSON_INVALID_RESPONSE_PAYLOAD_KEY, executionContext, policyChain, 500);
                                } else {
                                    this.writeBufferAndEnd();
                                }
                            } else {
                                this.writeBufferAndEnd();
                            }
                        }
                        catch (Exception ex) {
                            request.metrics().setMessage(ex.toString());
                            if (JsonValidationPolicy.this.configuration.isStraightRespondMode()) break block6;
                            JsonValidationPolicy.this.sendErrorResponse(JsonValidationPolicy.JSON_INVALID_RESPONSE_FORMAT_KEY, executionContext, policyChain, 500);
                        }
                    }
                }

                private void writeBufferAndEnd() {
                    if (this.buffer.length() > 0) {
                        super.write((Object)this.buffer);
                    }
                    super.end();
                }
            };
        }
        return null;
    }

    private ProcessingReport getReport(JsonNode schema, JsonNode content) throws ProcessingException {
        if (this.configuration.isValidateUnchecked()) {
            return validator.validateUnchecked(schema, content, this.configuration.isDeepCheck());
        }
        return validator.validate(schema, content, this.configuration.isDeepCheck());
    }

    private void sendErrorResponse(String key, ExecutionContext executionContext, PolicyChain policyChain, int httpStatusCode) {
        if (this.configuration.getErrorMessage() != null && !this.configuration.getErrorMessage().isEmpty()) {
            String errorMessage = executionContext.getTemplateEngine().convert(this.configuration.getErrorMessage());
            policyChain.streamFailWith(PolicyResult.failure((String)key, (int)httpStatusCode, (String)errorMessage, (String)"application/json"));
        } else {
            String errorMessage = httpStatusCode == 400 ? BAD_REQUEST : INTERNAL_ERROR;
            policyChain.streamFailWith(PolicyResult.failure((String)key, (int)httpStatusCode, (String)errorMessage, (String)"text/plain"));
        }
    }
}

