/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.policy.jsonvalidation.swagger;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import io.gravitee.policy.api.swagger.Policy;
import io.gravitee.policy.api.swagger.v3.OAIOperationVisitor;
import io.gravitee.policy.jsonvalidation.configuration.JsonValidationPolicyConfiguration;
import io.swagger.v3.core.util.Json;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.RequestBody;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class JsonValidationOAIOperationVisitor
implements OAIOperationVisitor {
    private final ObjectMapper mapper = new ObjectMapper();

    public JsonValidationOAIOperationVisitor() {
        this.mapper.configure(JsonGenerator.Feature.WRITE_NUMBERS_AS_STRINGS, true);
        this.mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        this.mapper.enable(SerializationFeature.INDENT_OUTPUT);
    }

    public Optional<Policy> visit(OpenAPI openAPI, Operation operation) {
        String jsonSchema = null;
        RequestBody requestBody = operation.getRequestBody();
        if (requestBody != null && requestBody.getContent() != null && requestBody.getContent().get((Object)"application/json") != null) {
            Schema schema = ((MediaType)requestBody.getContent().get((Object)"application/json")).getSchema();
            jsonSchema = Json.pretty((Object)schema);
        }
        if (!StringUtils.isEmpty(jsonSchema)) {
            JsonValidationPolicyConfiguration configuration = new JsonValidationPolicyConfiguration();
            try {
                Policy policy = new Policy();
                policy.setName("json-validation");
                configuration.setSchema(jsonSchema);
                policy.setConfiguration(this.mapper.writeValueAsString((Object)configuration));
                return Optional.of(policy);
            }
            catch (JsonProcessingException e) {
                e.printStackTrace();
            }
        }
        return Optional.empty();
    }
}

