/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.policy.json2xml;

import io.gravitee.gateway.api.buffer.Buffer;
import io.gravitee.gateway.api.http.HttpHeaders;
import io.gravitee.gateway.api.stream.exception.TransformationException;
import io.gravitee.gateway.reactive.api.ExecutionFailure;
import io.gravitee.gateway.reactive.api.context.HttpExecutionContext;
import io.gravitee.gateway.reactive.api.context.MessageExecutionContext;
import io.gravitee.gateway.reactive.api.message.Message;
import io.gravitee.gateway.reactive.api.policy.Policy;
import io.gravitee.policy.json2xml.configuration.JsonToXmlTransformationPolicyConfiguration;
import io.gravitee.policy.json2xml.transformer.JSONObject;
import io.gravitee.policy.json2xml.transformer.XML;
import io.gravitee.policy.json2xml.utils.CharsetHelper;
import io.gravitee.policy.v3.json2xml.JsonToXmlTransformationPolicyV3;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Maybe;
import io.reactivex.rxjava3.core.MaybeSource;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class JsonToXmlTransformationPolicy
extends JsonToXmlTransformationPolicyV3
implements Policy {
    private static final String INVALID_PAYLOAD_FAILURE_KEY = "JSON_INVALID_PAYLOAD";
    private static final String INVALID_MESSAGE_PAYLOAD_FAILURE_KEY = "JSON_INVALID_MESSAGE_PAYLOAD";

    public JsonToXmlTransformationPolicy(JsonToXmlTransformationPolicyConfiguration configuration) {
        super(configuration);
    }

    private static void setContentHeaders(HttpHeaders headers, Buffer xmlBuffer) {
        headers.set((CharSequence)"Content-Type", (CharSequence)"application/xml;charset=UTF-8");
        headers.set((CharSequence)"Content-Length", (CharSequence)Integer.toString(xmlBuffer.length()));
    }

    public String id() {
        return "json-xml";
    }

    public Completable onRequest(HttpExecutionContext ctx) {
        return ctx.request().onBody(body -> this.transformBodyToXml(ctx, (Maybe<Buffer>)body, ctx.request().headers(), 400));
    }

    public Completable onResponse(HttpExecutionContext ctx) {
        return ctx.response().onBody(body -> this.transformBodyToXml(ctx, (Maybe<Buffer>)body, ctx.response().headers(), 500));
    }

    private Maybe<Buffer> transformBodyToXml(HttpExecutionContext ctx, Maybe<Buffer> bodyUpstream, HttpHeaders httpHeaders, int failureHttpCode) {
        return bodyUpstream.flatMap(buffer -> this.transformToXml((Buffer)buffer, CharsetHelper.extractCharset(httpHeaders))).doOnSuccess(xmlBuffer -> JsonToXmlTransformationPolicy.setContentHeaders(httpHeaders, xmlBuffer)).onErrorResumeWith((MaybeSource)ctx.interruptBodyWith(new ExecutionFailure(failureHttpCode).key(INVALID_PAYLOAD_FAILURE_KEY).message("Unable to transform invalid JSON payload to XML")));
    }

    public Completable onMessageRequest(MessageExecutionContext ctx) {
        return ctx.request().onMessage(message -> this.transformMessageToXml(ctx, (Message)message, ctx.request().headers(), 400));
    }

    public Completable onMessageResponse(MessageExecutionContext ctx) {
        return ctx.response().onMessage(message -> this.transformMessageToXml(ctx, (Message)message, ctx.response().headers(), 500));
    }

    private Maybe<Message> transformMessageToXml(MessageExecutionContext ctx, Message message, HttpHeaders httpHeaders, int failureHttpCode) {
        return this.transformToXml(message.content(), CharsetHelper.extractCharset(httpHeaders)).map(arg_0 -> ((Message)message).content(arg_0)).doOnSuccess(xmlMessage -> JsonToXmlTransformationPolicy.setContentHeaders(message.headers(), xmlMessage.content())).onErrorResumeWith((MaybeSource)ctx.interruptMessageWith(new ExecutionFailure(failureHttpCode).key(INVALID_MESSAGE_PAYLOAD_FAILURE_KEY).message("Unable to transform invalid JSON message to XML")));
    }

    private Maybe<Buffer> transformToXml(Buffer buffer, Charset charset) {
        try {
            String encodedPayload = new String(buffer.toString(charset).getBytes(StandardCharsets.UTF_8));
            JSONObject jsonPayload = new JSONObject(encodedPayload);
            JSONObject jsonPayloadWithRoot = new JSONObject();
            jsonPayloadWithRoot.append(this.configuration.getRootElement(), jsonPayload);
            return Maybe.just((Object)Buffer.buffer((String)XML.toString(jsonPayloadWithRoot)));
        }
        catch (Exception ex) {
            return Maybe.error((Throwable)new TransformationException("Unable to transform JSON into XML: " + ex.getMessage(), (Throwable)ex));
        }
    }
}

