/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.policy.json2xml.utils;

import io.gravitee.gateway.api.http.HttpHeaders;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.regex.Pattern;

public class CharsetHelper {
    private static final Charset UTF_8_CHARSET = StandardCharsets.UTF_8;
    private static final String CHARSET_TAG = "charset=";
    private static final Pattern CHARSET_PATTERN = Pattern.compile(Pattern.quote("charset="), 2);

    public static Charset extractCharset(HttpHeaders httpHeaders) {
        return CharsetHelper.extractFromContentType(httpHeaders.get((CharSequence)"Content-Type"));
    }

    public static Charset extractFromContentType(String mediaType) {
        if (mediaType == null || !CHARSET_PATTERN.matcher(mediaType).find()) {
            return UTF_8_CHARSET;
        }
        String charsetName = mediaType.substring(mediaType.lastIndexOf(61) + 1);
        return Charset.isSupported(charsetName = charsetName.replace("\"", "")) ? Charset.forName(charsetName) : Charset.defaultCharset();
    }
}

