/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.policy.requestvalidation.validator;

import io.gravitee.policy.requestvalidation.validator.StringConstraintValidator;
import java.text.ParseException;
import java.text.SimpleDateFormat;

public class DateFormatConstraintValidator
extends StringConstraintValidator {
    private boolean init = false;
    private SimpleDateFormat dateFormat;

    @Override
    public void initialize(String ... parameters) {
        try {
            if (parameters != null && parameters.length > 0) {
                this.dateFormat = new SimpleDateFormat(parameters[0]);
                this.dateFormat.setLenient(false);
                this.init = true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public boolean isValid(String value) {
        if (value == null || !this.init) {
            return false;
        }
        try {
            this.dateFormat.parse(value);
            return true;
        }
        catch (ParseException pex) {
            return false;
        }
    }

    @Override
    public String getMessageTemplate() {
        return "'%s' is not valid (format: '%s')";
    }
}

