/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.policy.requestvalidation.validator;

import io.gravitee.policy.requestvalidation.Constraint;
import io.gravitee.policy.requestvalidation.ConstraintValidator;
import io.gravitee.policy.requestvalidation.ConstraintViolation;
import io.gravitee.policy.requestvalidation.Validator;

public class DefaultValidator
implements Validator {
    @Override
    public ConstraintViolation validate(String input, Constraint constraint) {
        Class<? extends ConstraintValidator> clazz = constraint.getType().validator();
        try {
            ConstraintValidator constraintValidator = clazz.newInstance();
            constraintValidator.initialize(constraint.getParameters());
            boolean valid = constraintValidator.isValid(input);
            if (!valid) {
                ConstraintViolation violation = new ConstraintViolation();
                String[] parameters = constraint.getParameters() != null ? constraint.getParameters() : new String[]{};
                Object[] inputs = new String[parameters.length + 1];
                inputs[0] = input;
                System.arraycopy(parameters, 0, inputs, 1, parameters.length);
                String message = constraint.getMessage() == null || constraint.getMessage().isEmpty() ? constraintValidator.getMessageTemplate() : constraint.getMessage();
                violation.setMessage(String.format(message, inputs));
                return violation;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }
}

