/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.policy.requestvalidation.validator;

import io.gravitee.policy.requestvalidation.validator.PatternConstraintValidator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MailConstraintValidator
extends PatternConstraintValidator {
    private static final Pattern VALID_EMAIL_ADDRESS_REGEX = Pattern.compile("^[A-Z0-9._%+-]+(@|%40)[A-Z0-9.-]+\\.[A-Z]{2,6}$", 2);

    @Override
    public boolean isValid(String value) {
        if (value == null) {
            return false;
        }
        Matcher matcher = VALID_EMAIL_ADDRESS_REGEX.matcher(value);
        return matcher.find();
    }

    @Override
    public String getMessageTemplate() {
        return "%s is not a valid email.";
    }
}

