/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.api.el;

import io.gravitee.common.util.LinkedCaseInsensitiveMultiValueMap;
import io.gravitee.common.util.MultiValueMap;
import java.security.Principal;
import java.util.Arrays;
import java.util.Hashtable;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x500.style.IETFUtils;

public class EvaluableSSLPrincipal {
    private final X500Principal principal;
    private X500Name x500Name;
    private MultiValueMap<String, String> attributes;

    public EvaluableSSLPrincipal(Principal principal) {
        this.principal = (X500Principal)principal;
    }

    public String getBusinessCategory() {
        return this.readFirstRDNByType(BCStyle.BUSINESS_CATEGORY);
    }

    public String getC() {
        return this.readFirstRDNByType(BCStyle.C);
    }

    public String getCn() {
        return this.readFirstRDNByType(BCStyle.CN);
    }

    public String getCountryOfCitizenship() {
        return this.readFirstRDNByType(BCStyle.COUNTRY_OF_CITIZENSHIP);
    }

    public String getCountryOfResidence() {
        return this.readFirstRDNByType(BCStyle.COUNTRY_OF_RESIDENCE);
    }

    public String getDateOfBirth() {
        return this.readFirstRDNByType(BCStyle.DATE_OF_BIRTH);
    }

    public String getDc() {
        return this.readFirstRDNByType(BCStyle.DC);
    }

    public String getDescription() {
        return this.readFirstRDNByType(BCStyle.DESCRIPTION);
    }

    public String getDmdName() {
        return this.readFirstRDNByType(BCStyle.DMD_NAME);
    }

    public String getDnQualifier() {
        return this.readFirstRDNByType(BCStyle.DN_QUALIFIER);
    }

    public String getE() {
        return this.readFirstRDNByType(BCStyle.E);
    }

    public String getEmailAddress() {
        return this.readFirstRDNByType(BCStyle.EmailAddress);
    }

    public String getGender() {
        return this.readFirstRDNByType(BCStyle.GENDER);
    }

    public String getGeneration() {
        return this.readFirstRDNByType(BCStyle.GENERATION);
    }

    public String getGivenname() {
        return this.readFirstRDNByType(BCStyle.GIVENNAME);
    }

    public String getInitials() {
        return this.readFirstRDNByType(BCStyle.INITIALS);
    }

    public String getL() {
        return this.readFirstRDNByType(BCStyle.L);
    }

    public String getName() {
        return this.readFirstRDNByType(BCStyle.NAME);
    }

    public String getNameAtBirth() {
        return this.readFirstRDNByType(BCStyle.NAME_AT_BIRTH);
    }

    public String getO() {
        return this.readFirstRDNByType(BCStyle.O);
    }

    public String getOrganizationIdentifier() {
        return this.readFirstRDNByType(BCStyle.ORGANIZATION_IDENTIFIER);
    }

    public String getOu() {
        return this.readFirstRDNByType(BCStyle.OU);
    }

    public String getPlaceOfBirth() {
        return this.readFirstRDNByType(BCStyle.PLACE_OF_BIRTH);
    }

    public String getPostalAddress() {
        return this.readFirstRDNByType(BCStyle.POSTAL_ADDRESS);
    }

    public String getPostalCode() {
        return this.readFirstRDNByType(BCStyle.POSTAL_CODE);
    }

    public String getPseudonym() {
        return this.readFirstRDNByType(BCStyle.PSEUDONYM);
    }

    public String getRole() {
        return this.readFirstRDNByType(BCStyle.ROLE);
    }

    public String getSerialnumber() {
        return this.readFirstRDNByType(BCStyle.SERIALNUMBER);
    }

    public String getSt() {
        return this.readFirstRDNByType(BCStyle.ST);
    }

    public String getStreet() {
        return this.readFirstRDNByType(BCStyle.STREET);
    }

    public String getSurname() {
        return this.readFirstRDNByType(BCStyle.SURNAME);
    }

    public String getT() {
        return this.readFirstRDNByType(BCStyle.T);
    }

    public String getTelephoneNumber() {
        return this.readFirstRDNByType(BCStyle.TELEPHONE_NUMBER);
    }

    public String getUid() {
        return this.readFirstRDNByType(BCStyle.UID);
    }

    public String getUniqueIdentifier() {
        return this.readFirstRDNByType(BCStyle.UNIQUE_IDENTIFIER);
    }

    public String getUnstructuredAddress() {
        return this.readFirstRDNByType(BCStyle.UnstructuredAddress);
    }

    public String getDn() {
        return this.principal.getName();
    }

    public MultiValueMap<String, String> getAttributes() {
        if (this.attributes == null) {
            this.attributes = this.computeSSLAttributes();
        }
        return this.attributes;
    }

    public boolean isDefined() {
        return this.principal != null;
    }

    private String readFirstRDNByType(ASN1ObjectIdentifier objectIdentifier) {
        RDN[] rdns = this.readRdnsFromPrincipalName(objectIdentifier);
        if (rdns.length > 0) {
            return IETFUtils.valueToString((ASN1Encodable)rdns[0].getFirst().getValue());
        }
        return null;
    }

    private RDN[] readRdnsFromPrincipalName(ASN1ObjectIdentifier objectIdentifier) {
        if (this.x500Name == null) {
            this.x500Name = new X500Name(this.principal.getName());
        }
        return this.x500Name.getRDNs(objectIdentifier);
    }

    private MultiValueMap<String, String> computeSSLAttributes() {
        class AccessibleBCStyle
        extends BCStyle {
            AccessibleBCStyle() {
            }

            Hashtable<ASN1ObjectIdentifier, String> getDefaultSymbols() {
                return this.defaultSymbols;
            }
        }
        AccessibleBCStyle bcStyle = new AccessibleBCStyle();
        LinkedCaseInsensitiveMultiValueMap computedAttributes = new LinkedCaseInsensitiveMultiValueMap();
        RDN[] rdns = this.readAllRdnsFromPrincipalName();
        Arrays.stream(rdns).forEach(rdn -> {
            ASN1ObjectIdentifier type = rdn.getFirst().getType();
            String value = IETFUtils.valueToString((ASN1Encodable)rdn.getFirst().getValue());
            computedAttributes.add((Object)type.getId(), (Object)value);
            String symbol = bcStyle.getDefaultSymbols().get(type);
            if (symbol != null) {
                computedAttributes.add((Object)symbol, (Object)value);
            }
        });
        return computedAttributes;
    }

    private RDN[] readAllRdnsFromPrincipalName() {
        if (this.x500Name == null) {
            this.x500Name = new X500Name(this.principal.getName());
        }
        return this.x500Name.getRDNs();
    }
}

