/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.api.http;

import io.gravitee.gateway.api.http.DefaultHttpHeaders;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public interface HttpHeaders
extends Iterable<Map.Entry<String, String>> {
    public static HttpHeaders create() {
        return new DefaultHttpHeaders();
    }

    public static HttpHeaders create(HttpHeaders headers) {
        return new DefaultHttpHeaders(headers);
    }

    default public String getFirst(CharSequence name) {
        return this.get(name);
    }

    public String get(CharSequence var1);

    public List<String> getAll(CharSequence var1);

    default public boolean containsKey(CharSequence name) {
        return this.containsKey(String.valueOf(name));
    }

    default public boolean containsKey(String name) {
        return this.contains(name);
    }

    public boolean contains(CharSequence var1);

    default public boolean contains(String name) {
        return this.contains((CharSequence)name);
    }

    public Set<String> names();

    public HttpHeaders add(CharSequence var1, CharSequence var2);

    public HttpHeaders add(CharSequence var1, Iterable<CharSequence> var2);

    public HttpHeaders set(CharSequence var1, CharSequence var2);

    public HttpHeaders set(CharSequence var1, Iterable<CharSequence> var2);

    public HttpHeaders remove(CharSequence var1);

    public void clear();

    public int size();

    public boolean isEmpty();

    default public List<String> getOrDefault(CharSequence key, List<String> defaultValue) {
        List<String> v = this.getAll(key);
        return v != null || this.containsKey(key.toString()) ? v : defaultValue;
    }

    default public Map<String, String> toSingleValueMap() {
        LinkedHashMap<String, String> singleValueMap = new LinkedHashMap<String, String>(this.size());
        for (Map.Entry entry : this) {
            singleValueMap.putIfAbsent((String)entry.getKey(), (String)entry.getValue());
        }
        return singleValueMap;
    }

    default public Map<String, List<String>> toListValuesMap() {
        return this.names().stream().collect(Collectors.toMap(s -> s, this::getAll, (o1, o2) -> o1, () -> new LinkedHashMap(this.size())));
    }

    default public boolean containsAllKeys(Collection<String> names) {
        return this.names().containsAll(names.stream().map(String::toLowerCase).collect(Collectors.toList()));
    }

    default public boolean deeplyEquals(HttpHeaders other) {
        if (this.size() != other.size() || !this.names().containsAll(other.names())) {
            return false;
        }
        for (String name : this.names()) {
            List<String> otherValues = other.getAll(name);
            if (otherValues.equals(this.getAll(name))) continue;
            return false;
        }
        return true;
    }
}

