/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.api.service;

import io.gravitee.gateway.api.service.SubscriptionConfiguration;
import java.util.Date;
import java.util.Map;
import lombok.Generated;

public class Subscription {
    private String id;
    private String api;
    private String plan;
    private String application;
    private String applicationName;
    private String clientId;
    private String clientCertificate;
    private String status;
    private ConsumerStatus consumerStatus;
    private Date startingAt;
    private Date endingAt;
    private SubscriptionConfiguration configuration;
    private Map<String, String> metadata;
    private Type type;
    private boolean forceDispatch;
    private String environmentId;

    public boolean isTimeValid(long requestTimestamp) {
        Date requestDate = new Date(requestTimestamp);
        return !(this.endingAt != null && !this.endingAt.after(requestDate) || this.startingAt != null && !this.startingAt.before(requestDate));
    }

    @Generated
    private static ConsumerStatus $default$consumerStatus() {
        return ConsumerStatus.STARTED;
    }

    @Generated
    private static Type $default$type() {
        return Type.STANDARD;
    }

    @Generated
    public static SubscriptionBuilder builder() {
        return new SubscriptionBuilder();
    }

    @Generated
    public Subscription() {
        this.consumerStatus = Subscription.$default$consumerStatus();
        this.type = Subscription.$default$type();
    }

    @Generated
    public Subscription(String id, String api, String plan, String application, String applicationName, String clientId, String clientCertificate, String status, ConsumerStatus consumerStatus, Date startingAt, Date endingAt, SubscriptionConfiguration configuration, Map<String, String> metadata, Type type, boolean forceDispatch, String environmentId) {
        this.id = id;
        this.api = api;
        this.plan = plan;
        this.application = application;
        this.applicationName = applicationName;
        this.clientId = clientId;
        this.clientCertificate = clientCertificate;
        this.status = status;
        this.consumerStatus = consumerStatus;
        this.startingAt = startingAt;
        this.endingAt = endingAt;
        this.configuration = configuration;
        this.metadata = metadata;
        this.type = type;
        this.forceDispatch = forceDispatch;
        this.environmentId = environmentId;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getApi() {
        return this.api;
    }

    @Generated
    public String getPlan() {
        return this.plan;
    }

    @Generated
    public String getApplication() {
        return this.application;
    }

    @Generated
    public String getApplicationName() {
        return this.applicationName;
    }

    @Generated
    public String getClientId() {
        return this.clientId;
    }

    @Generated
    public String getClientCertificate() {
        return this.clientCertificate;
    }

    @Generated
    public String getStatus() {
        return this.status;
    }

    @Generated
    public ConsumerStatus getConsumerStatus() {
        return this.consumerStatus;
    }

    @Generated
    public Date getStartingAt() {
        return this.startingAt;
    }

    @Generated
    public Date getEndingAt() {
        return this.endingAt;
    }

    @Generated
    public SubscriptionConfiguration getConfiguration() {
        return this.configuration;
    }

    @Generated
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    @Generated
    public Type getType() {
        return this.type;
    }

    @Generated
    public boolean isForceDispatch() {
        return this.forceDispatch;
    }

    @Generated
    public String getEnvironmentId() {
        return this.environmentId;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setApi(String api) {
        this.api = api;
    }

    @Generated
    public void setPlan(String plan) {
        this.plan = plan;
    }

    @Generated
    public void setApplication(String application) {
        this.application = application;
    }

    @Generated
    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    @Generated
    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    @Generated
    public void setClientCertificate(String clientCertificate) {
        this.clientCertificate = clientCertificate;
    }

    @Generated
    public void setStatus(String status) {
        this.status = status;
    }

    @Generated
    public void setConsumerStatus(ConsumerStatus consumerStatus) {
        this.consumerStatus = consumerStatus;
    }

    @Generated
    public void setStartingAt(Date startingAt) {
        this.startingAt = startingAt;
    }

    @Generated
    public void setEndingAt(Date endingAt) {
        this.endingAt = endingAt;
    }

    @Generated
    public void setConfiguration(SubscriptionConfiguration configuration) {
        this.configuration = configuration;
    }

    @Generated
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    @Generated
    public void setType(Type type) {
        this.type = type;
    }

    @Generated
    public void setForceDispatch(boolean forceDispatch) {
        this.forceDispatch = forceDispatch;
    }

    @Generated
    public void setEnvironmentId(String environmentId) {
        this.environmentId = environmentId;
    }

    @Generated
    public String toString() {
        return "Subscription(id=" + this.getId() + ", api=" + this.getApi() + ", plan=" + this.getPlan() + ", application=" + this.getApplication() + ", applicationName=" + this.getApplicationName() + ", clientId=" + this.getClientId() + ", clientCertificate=" + this.getClientCertificate() + ", status=" + this.getStatus() + ", consumerStatus=" + String.valueOf((Object)this.getConsumerStatus()) + ", startingAt=" + String.valueOf(this.getStartingAt()) + ", endingAt=" + String.valueOf(this.getEndingAt()) + ", configuration=" + String.valueOf(this.getConfiguration()) + ", metadata=" + String.valueOf(this.getMetadata()) + ", type=" + String.valueOf((Object)this.getType()) + ", forceDispatch=" + this.isForceDispatch() + ", environmentId=" + this.getEnvironmentId() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Subscription)) {
            return false;
        }
        Subscription other = (Subscription)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$api = this.getApi();
        String other$api = other.getApi();
        if (this$api == null ? other$api != null : !this$api.equals(other$api)) {
            return false;
        }
        String this$plan = this.getPlan();
        String other$plan = other.getPlan();
        if (this$plan == null ? other$plan != null : !this$plan.equals(other$plan)) {
            return false;
        }
        String this$application = this.getApplication();
        String other$application = other.getApplication();
        if (this$application == null ? other$application != null : !this$application.equals(other$application)) {
            return false;
        }
        String this$applicationName = this.getApplicationName();
        String other$applicationName = other.getApplicationName();
        if (this$applicationName == null ? other$applicationName != null : !this$applicationName.equals(other$applicationName)) {
            return false;
        }
        String this$clientId = this.getClientId();
        String other$clientId = other.getClientId();
        if (this$clientId == null ? other$clientId != null : !this$clientId.equals(other$clientId)) {
            return false;
        }
        String this$clientCertificate = this.getClientCertificate();
        String other$clientCertificate = other.getClientCertificate();
        if (this$clientCertificate == null ? other$clientCertificate != null : !this$clientCertificate.equals(other$clientCertificate)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        ConsumerStatus this$consumerStatus = this.getConsumerStatus();
        ConsumerStatus other$consumerStatus = other.getConsumerStatus();
        if (this$consumerStatus == null ? other$consumerStatus != null : !((Object)((Object)this$consumerStatus)).equals((Object)other$consumerStatus)) {
            return false;
        }
        Date this$startingAt = this.getStartingAt();
        Date other$startingAt = other.getStartingAt();
        if (this$startingAt == null ? other$startingAt != null : !((Object)this$startingAt).equals(other$startingAt)) {
            return false;
        }
        Date this$endingAt = this.getEndingAt();
        Date other$endingAt = other.getEndingAt();
        if (this$endingAt == null ? other$endingAt != null : !((Object)this$endingAt).equals(other$endingAt)) {
            return false;
        }
        SubscriptionConfiguration this$configuration = this.getConfiguration();
        SubscriptionConfiguration other$configuration = other.getConfiguration();
        if (this$configuration == null ? other$configuration != null : !((Object)this$configuration).equals(other$configuration)) {
            return false;
        }
        Map<String, String> this$metadata = this.getMetadata();
        Map<String, String> other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        Type this$type = this.getType();
        Type other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        String this$environmentId = this.getEnvironmentId();
        String other$environmentId = other.getEnvironmentId();
        return !(this$environmentId == null ? other$environmentId != null : !this$environmentId.equals(other$environmentId));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Subscription;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $api = this.getApi();
        result = result * 59 + ($api == null ? 43 : $api.hashCode());
        String $plan = this.getPlan();
        result = result * 59 + ($plan == null ? 43 : $plan.hashCode());
        String $application = this.getApplication();
        result = result * 59 + ($application == null ? 43 : $application.hashCode());
        String $applicationName = this.getApplicationName();
        result = result * 59 + ($applicationName == null ? 43 : $applicationName.hashCode());
        String $clientId = this.getClientId();
        result = result * 59 + ($clientId == null ? 43 : $clientId.hashCode());
        String $clientCertificate = this.getClientCertificate();
        result = result * 59 + ($clientCertificate == null ? 43 : $clientCertificate.hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        ConsumerStatus $consumerStatus = this.getConsumerStatus();
        result = result * 59 + ($consumerStatus == null ? 43 : ((Object)((Object)$consumerStatus)).hashCode());
        Date $startingAt = this.getStartingAt();
        result = result * 59 + ($startingAt == null ? 43 : ((Object)$startingAt).hashCode());
        Date $endingAt = this.getEndingAt();
        result = result * 59 + ($endingAt == null ? 43 : ((Object)$endingAt).hashCode());
        SubscriptionConfiguration $configuration = this.getConfiguration();
        result = result * 59 + ($configuration == null ? 43 : ((Object)$configuration).hashCode());
        Map<String, String> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        Type $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        String $environmentId = this.getEnvironmentId();
        result = result * 59 + ($environmentId == null ? 43 : $environmentId.hashCode());
        return result;
    }

    public static enum ConsumerStatus {
        STOPPED,
        STARTED,
        FAILURE;

    }

    public static enum Type {
        STANDARD,
        PUSH;

    }

    @Generated
    public static class SubscriptionBuilder {
        @Generated
        private String id;
        @Generated
        private String api;
        @Generated
        private String plan;
        @Generated
        private String application;
        @Generated
        private String applicationName;
        @Generated
        private String clientId;
        @Generated
        private String clientCertificate;
        @Generated
        private String status;
        @Generated
        private boolean consumerStatus$set;
        @Generated
        private ConsumerStatus consumerStatus$value;
        @Generated
        private Date startingAt;
        @Generated
        private Date endingAt;
        @Generated
        private SubscriptionConfiguration configuration;
        @Generated
        private Map<String, String> metadata;
        @Generated
        private boolean type$set;
        @Generated
        private Type type$value;
        @Generated
        private boolean forceDispatch;
        @Generated
        private String environmentId;

        @Generated
        SubscriptionBuilder() {
        }

        @Generated
        public SubscriptionBuilder id(String id) {
            this.id = id;
            return this;
        }

        @Generated
        public SubscriptionBuilder api(String api) {
            this.api = api;
            return this;
        }

        @Generated
        public SubscriptionBuilder plan(String plan) {
            this.plan = plan;
            return this;
        }

        @Generated
        public SubscriptionBuilder application(String application) {
            this.application = application;
            return this;
        }

        @Generated
        public SubscriptionBuilder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        @Generated
        public SubscriptionBuilder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        @Generated
        public SubscriptionBuilder clientCertificate(String clientCertificate) {
            this.clientCertificate = clientCertificate;
            return this;
        }

        @Generated
        public SubscriptionBuilder status(String status) {
            this.status = status;
            return this;
        }

        @Generated
        public SubscriptionBuilder consumerStatus(ConsumerStatus consumerStatus) {
            this.consumerStatus$value = consumerStatus;
            this.consumerStatus$set = true;
            return this;
        }

        @Generated
        public SubscriptionBuilder startingAt(Date startingAt) {
            this.startingAt = startingAt;
            return this;
        }

        @Generated
        public SubscriptionBuilder endingAt(Date endingAt) {
            this.endingAt = endingAt;
            return this;
        }

        @Generated
        public SubscriptionBuilder configuration(SubscriptionConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        @Generated
        public SubscriptionBuilder metadata(Map<String, String> metadata) {
            this.metadata = metadata;
            return this;
        }

        @Generated
        public SubscriptionBuilder type(Type type) {
            this.type$value = type;
            this.type$set = true;
            return this;
        }

        @Generated
        public SubscriptionBuilder forceDispatch(boolean forceDispatch) {
            this.forceDispatch = forceDispatch;
            return this;
        }

        @Generated
        public SubscriptionBuilder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        @Generated
        public Subscription build() {
            ConsumerStatus consumerStatus$value = this.consumerStatus$value;
            if (!this.consumerStatus$set) {
                consumerStatus$value = Subscription.$default$consumerStatus();
            }
            Type type$value = this.type$value;
            if (!this.type$set) {
                type$value = Subscription.$default$type();
            }
            return new Subscription(this.id, this.api, this.plan, this.application, this.applicationName, this.clientId, this.clientCertificate, this.status, consumerStatus$value, this.startingAt, this.endingAt, this.configuration, this.metadata, type$value, this.forceDispatch, this.environmentId);
        }

        @Generated
        public String toString() {
            return "Subscription.SubscriptionBuilder(id=" + this.id + ", api=" + this.api + ", plan=" + this.plan + ", application=" + this.application + ", applicationName=" + this.applicationName + ", clientId=" + this.clientId + ", clientCertificate=" + this.clientCertificate + ", status=" + this.status + ", consumerStatus$value=" + String.valueOf((Object)this.consumerStatus$value) + ", startingAt=" + String.valueOf(this.startingAt) + ", endingAt=" + String.valueOf(this.endingAt) + ", configuration=" + String.valueOf(this.configuration) + ", metadata=" + String.valueOf(this.metadata) + ", type$value=" + String.valueOf((Object)this.type$value) + ", forceDispatch=" + this.forceDispatch + ", environmentId=" + this.environmentId + ")";
        }
    }
}

