/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.reactive.api.message;

import io.gravitee.common.util.ListUtils;
import io.gravitee.gateway.reactive.api.message.Message;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class AbstractMessage
implements Message {
    public static final String SOURCE_TIMESTAMP = "sourceTimestamp";
    protected final long timestamp;
    protected final long sourceTimestamp;
    protected final Map<String, Object> metadata;
    protected Map<String, Object> attributes;
    protected Map<String, Object> internalAttributes;

    protected AbstractMessage(long timestamp, long sourceTimestamp, Map<String, Object> metadata, Map<String, Object> attributes, Map<String, Object> internalAttributes) {
        this.timestamp = timestamp != 0L ? timestamp : System.currentTimeMillis();
        this.sourceTimestamp = sourceTimestamp != 0L ? sourceTimestamp : this.timestamp;
        this.metadata = AbstractMessage.initMetadata(metadata, this.sourceTimestamp);
        this.attributes = attributes;
        this.internalAttributes = internalAttributes;
    }

    @Override
    public long timestamp() {
        return this.timestamp;
    }

    @Override
    public Map<String, Object> metadata() {
        return this.metadata;
    }

    @Override
    public <T> T attribute(String name) {
        return (T)this.getOrInitAttribute().get(name);
    }

    @Override
    public <T> List<T> attributeAsList(String name) {
        return ListUtils.toList((Object)this.getOrInitAttribute().get(name));
    }

    @Override
    public Message attribute(String name, Object value) {
        this.getOrInitAttribute().put(name, value);
        return this;
    }

    @Override
    public Message removeAttribute(String name) {
        this.getOrInitAttribute().remove(name);
        return this;
    }

    @Override
    public Set<String> attributeNames() {
        return this.getOrInitAttribute().keySet();
    }

    @Override
    public <T> Map<String, T> attributes() {
        return Collections.unmodifiableMap(this.getOrInitAttribute());
    }

    @Override
    public <T> T internalAttribute(String name) {
        return (T)this.getOrInitInternalAttribute().get(name);
    }

    @Override
    public Message internalAttribute(String name, Object value) {
        this.getOrInitInternalAttribute().put(name, value);
        return this;
    }

    @Override
    public Message removeInternalAttribute(String name) {
        this.getOrInitInternalAttribute().remove(name);
        return this;
    }

    @Override
    public Set<String> internalAttributeNames() {
        return this.getOrInitInternalAttribute().keySet();
    }

    @Override
    public <T> Map<String, T> internalAttributes() {
        return Collections.unmodifiableMap(this.getOrInitInternalAttribute());
    }

    private Map<String, Object> getOrInitAttribute() {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, Object>();
        }
        return this.attributes;
    }

    private Map<String, Object> getOrInitInternalAttribute() {
        if (this.internalAttributes == null) {
            this.internalAttributes = new HashMap<String, Object>();
        }
        return this.internalAttributes;
    }

    protected static Map<String, Object> unmodifiableMetadata(Map<String, Object> metadata) {
        if (metadata != null) {
            return Collections.unmodifiableMap(metadata);
        }
        return Map.of();
    }

    private static Map<String, Object> initMetadata(Map<String, Object> metadata, long sourceTimestamp) {
        if (metadata == null) {
            metadata = new HashMap<String, Object>();
        }
        if (!metadata.containsKey(SOURCE_TIMESTAMP)) {
            metadata.put(SOURCE_TIMESTAMP, sourceTimestamp);
        }
        return AbstractMessage.unmodifiableMetadata(metadata);
    }
}

