/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.reactive.api.message;

import io.gravitee.gateway.api.buffer.Buffer;
import io.gravitee.gateway.api.http.HttpHeaders;
import io.gravitee.gateway.reactive.api.message.AbstractMessage;
import io.gravitee.gateway.reactive.api.tracing.message.TracingMessage;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import lombok.Generated;

public class DefaultMessage
extends AbstractMessage
implements TracingMessage {
    private String id;
    private String correlationId;
    private String parentCorrelationId;
    private HttpHeaders headers;
    private Buffer content;
    private boolean error;
    private Runnable ackRunnable;
    private Runnable endRunnable;
    private boolean ended;
    private Map<String, String> tracingAttributes;

    private DefaultMessage(DefaultMessageBuilder b) {
        super(b.timestamp, b.sourceTimestamp, b.metadata, b.attributes, b.internalAttributes);
        this.attributes = b.attributes;
        this.internalAttributes = b.internalAttributes;
        this.id = b.id;
        this.correlationId = b.correlationId != null ? b.correlationId : UUID.randomUUID().toString();
        this.parentCorrelationId = b.parentCorrelationId;
        this.headers = b.headers;
        this.content = b.content;
        this.error = b.error;
        this.ackRunnable = b.ackRunnable;
        this.endRunnable = b.endRunnable;
        this.ended = b.ended;
        this.tracingAttributes = b.tracingAttributes;
    }

    @Override
    public HttpHeaders headers() {
        if (this.headers == null) {
            this.headers = HttpHeaders.create();
        }
        return this.headers;
    }

    @Override
    public DefaultMessage content(Buffer content) {
        this.content = content;
        return this;
    }

    @Override
    public DefaultMessage content(String content) {
        if (content != null) {
            this.content(Buffer.buffer(content));
        } else {
            this.content((Buffer)null);
        }
        return this;
    }

    @Override
    public void ack() {
        if (this.ackRunnable != null) {
            this.ackRunnable.run();
        }
        if (!this.ended) {
            this.end();
        }
    }

    @Override
    public DefaultMessage doOnEnd(Runnable runnable) {
        this.endRunnable = runnable;
        return this;
    }

    @Override
    public void end() {
        if (this.endRunnable != null) {
            this.endRunnable.run();
        }
        this.ended = true;
    }

    @Override
    public Map<String, String> tracingAttributes() {
        if (this.tracingAttributes == null) {
            this.tracingAttributes = new HashMap<String, String>();
        }
        return this.tracingAttributes;
    }

    @Override
    public void addTracingAttribute(String key, String value) {
        if (key == null || value == null) {
            throw new IllegalArgumentException("Key or value of tracing attribute cannot be null");
        }
        if (this.tracingAttributes == null) {
            this.tracingAttributes = new HashMap<String, String>();
        }
        this.tracingAttributes.put(key, value);
    }

    public static DefaultMessageBuilder builder() {
        return new DefaultMessageBuilder();
    }

    @Override
    @Generated
    public String id() {
        return this.id;
    }

    @Override
    @Generated
    public String correlationId() {
        return this.correlationId;
    }

    @Override
    @Generated
    public String parentCorrelationId() {
        return this.parentCorrelationId;
    }

    @Override
    @Generated
    public Buffer content() {
        return this.content;
    }

    @Override
    @Generated
    public boolean error() {
        return this.error;
    }

    @Generated
    public Runnable ackRunnable() {
        return this.ackRunnable;
    }

    @Generated
    public Runnable endRunnable() {
        return this.endRunnable;
    }

    @Generated
    public boolean ended() {
        return this.ended;
    }

    @Generated
    public DefaultMessage id(String id) {
        this.id = id;
        return this;
    }

    @Generated
    public DefaultMessage correlationId(String correlationId) {
        this.correlationId = correlationId;
        return this;
    }

    @Generated
    public DefaultMessage parentCorrelationId(String parentCorrelationId) {
        this.parentCorrelationId = parentCorrelationId;
        return this;
    }

    @Override
    @Generated
    public DefaultMessage headers(HttpHeaders headers) {
        this.headers = headers;
        return this;
    }

    @Override
    @Generated
    public DefaultMessage error(boolean error) {
        this.error = error;
        return this;
    }

    @Generated
    public DefaultMessage ackRunnable(Runnable ackRunnable) {
        this.ackRunnable = ackRunnable;
        return this;
    }

    @Generated
    public DefaultMessage endRunnable(Runnable endRunnable) {
        this.endRunnable = endRunnable;
        return this;
    }

    @Generated
    public DefaultMessage ended(boolean ended) {
        this.ended = ended;
        return this;
    }

    @Generated
    public DefaultMessage tracingAttributes(Map<String, String> tracingAttributes) {
        this.tracingAttributes = tracingAttributes;
        return this;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DefaultMessage)) {
            return false;
        }
        DefaultMessage other = (DefaultMessage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.error() != other.error()) {
            return false;
        }
        if (this.ended() != other.ended()) {
            return false;
        }
        String this$id = this.id();
        String other$id = other.id();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$correlationId = this.correlationId();
        String other$correlationId = other.correlationId();
        if (this$correlationId == null ? other$correlationId != null : !this$correlationId.equals(other$correlationId)) {
            return false;
        }
        String this$parentCorrelationId = this.parentCorrelationId();
        String other$parentCorrelationId = other.parentCorrelationId();
        if (this$parentCorrelationId == null ? other$parentCorrelationId != null : !this$parentCorrelationId.equals(other$parentCorrelationId)) {
            return false;
        }
        HttpHeaders this$headers = this.headers();
        HttpHeaders other$headers = other.headers();
        if (this$headers == null ? other$headers != null : !this$headers.equals(other$headers)) {
            return false;
        }
        Buffer this$content = this.content();
        Buffer other$content = other.content();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        Runnable this$ackRunnable = this.ackRunnable();
        Runnable other$ackRunnable = other.ackRunnable();
        if (this$ackRunnable == null ? other$ackRunnable != null : !this$ackRunnable.equals(other$ackRunnable)) {
            return false;
        }
        Runnable this$endRunnable = this.endRunnable();
        Runnable other$endRunnable = other.endRunnable();
        if (this$endRunnable == null ? other$endRunnable != null : !this$endRunnable.equals(other$endRunnable)) {
            return false;
        }
        Map<String, String> this$tracingAttributes = this.tracingAttributes();
        Map<String, String> other$tracingAttributes = other.tracingAttributes();
        return !(this$tracingAttributes == null ? other$tracingAttributes != null : !((Object)this$tracingAttributes).equals(other$tracingAttributes));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DefaultMessage;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.error() ? 79 : 97);
        result = result * 59 + (this.ended() ? 79 : 97);
        String $id = this.id();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $correlationId = this.correlationId();
        result = result * 59 + ($correlationId == null ? 43 : $correlationId.hashCode());
        String $parentCorrelationId = this.parentCorrelationId();
        result = result * 59 + ($parentCorrelationId == null ? 43 : $parentCorrelationId.hashCode());
        HttpHeaders $headers = this.headers();
        result = result * 59 + ($headers == null ? 43 : $headers.hashCode());
        Buffer $content = this.content();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        Runnable $ackRunnable = this.ackRunnable();
        result = result * 59 + ($ackRunnable == null ? 43 : $ackRunnable.hashCode());
        Runnable $endRunnable = this.endRunnable();
        result = result * 59 + ($endRunnable == null ? 43 : $endRunnable.hashCode());
        Map<String, String> $tracingAttributes = this.tracingAttributes();
        result = result * 59 + ($tracingAttributes == null ? 43 : ((Object)$tracingAttributes).hashCode());
        return result;
    }

    public static class DefaultMessageBuilder {
        private long timestamp;
        private long sourceTimestamp;
        private Map<String, Object> metadata;
        private Map<String, Object> attributes;
        private Map<String, Object> internalAttributes;
        private String id;
        private String correlationId;
        private String parentCorrelationId;
        private HttpHeaders headers;
        private Buffer content;
        private boolean error;
        private Runnable ackRunnable;
        private Runnable endRunnable;
        private boolean ended;
        private Map<String, String> tracingAttributes;

        public DefaultMessageBuilder content(String content) {
            if (content != null) {
                this.content = Buffer.buffer(content);
            }
            return this;
        }

        public DefaultMessageBuilder content(Buffer content) {
            this.content = content;
            return this;
        }

        public DefaultMessage build() {
            return new DefaultMessage(this);
        }

        @Generated
        public DefaultMessageBuilder() {
        }

        @Generated
        public long timestamp() {
            return this.timestamp;
        }

        @Generated
        public long sourceTimestamp() {
            return this.sourceTimestamp;
        }

        @Generated
        public Map<String, Object> metadata() {
            return this.metadata;
        }

        @Generated
        public Map<String, Object> attributes() {
            return this.attributes;
        }

        @Generated
        public Map<String, Object> internalAttributes() {
            return this.internalAttributes;
        }

        @Generated
        public String id() {
            return this.id;
        }

        @Generated
        public String correlationId() {
            return this.correlationId;
        }

        @Generated
        public String parentCorrelationId() {
            return this.parentCorrelationId;
        }

        @Generated
        public HttpHeaders headers() {
            return this.headers;
        }

        @Generated
        public Buffer content() {
            return this.content;
        }

        @Generated
        public boolean error() {
            return this.error;
        }

        @Generated
        public Runnable ackRunnable() {
            return this.ackRunnable;
        }

        @Generated
        public Runnable endRunnable() {
            return this.endRunnable;
        }

        @Generated
        public boolean ended() {
            return this.ended;
        }

        @Generated
        public Map<String, String> tracingAttributes() {
            return this.tracingAttributes;
        }

        @Generated
        public DefaultMessageBuilder timestamp(long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        @Generated
        public DefaultMessageBuilder sourceTimestamp(long sourceTimestamp) {
            this.sourceTimestamp = sourceTimestamp;
            return this;
        }

        @Generated
        public DefaultMessageBuilder metadata(Map<String, Object> metadata) {
            this.metadata = metadata;
            return this;
        }

        @Generated
        public DefaultMessageBuilder attributes(Map<String, Object> attributes) {
            this.attributes = attributes;
            return this;
        }

        @Generated
        public DefaultMessageBuilder internalAttributes(Map<String, Object> internalAttributes) {
            this.internalAttributes = internalAttributes;
            return this;
        }

        @Generated
        public DefaultMessageBuilder id(String id) {
            this.id = id;
            return this;
        }

        @Generated
        public DefaultMessageBuilder correlationId(String correlationId) {
            this.correlationId = correlationId;
            return this;
        }

        @Generated
        public DefaultMessageBuilder parentCorrelationId(String parentCorrelationId) {
            this.parentCorrelationId = parentCorrelationId;
            return this;
        }

        @Generated
        public DefaultMessageBuilder headers(HttpHeaders headers) {
            this.headers = headers;
            return this;
        }

        @Generated
        public DefaultMessageBuilder error(boolean error) {
            this.error = error;
            return this;
        }

        @Generated
        public DefaultMessageBuilder ackRunnable(Runnable ackRunnable) {
            this.ackRunnable = ackRunnable;
            return this;
        }

        @Generated
        public DefaultMessageBuilder endRunnable(Runnable endRunnable) {
            this.endRunnable = endRunnable;
            return this;
        }

        @Generated
        public DefaultMessageBuilder ended(boolean ended) {
            this.ended = ended;
            return this;
        }

        @Generated
        public DefaultMessageBuilder tracingAttributes(Map<String, String> tracingAttributes) {
            this.tracingAttributes = tracingAttributes;
            return this;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DefaultMessageBuilder)) {
                return false;
            }
            DefaultMessageBuilder other = (DefaultMessageBuilder)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.timestamp() != other.timestamp()) {
                return false;
            }
            if (this.sourceTimestamp() != other.sourceTimestamp()) {
                return false;
            }
            if (this.error() != other.error()) {
                return false;
            }
            if (this.ended() != other.ended()) {
                return false;
            }
            Map<String, Object> this$metadata = this.metadata();
            Map<String, Object> other$metadata = other.metadata();
            if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
                return false;
            }
            Map<String, Object> this$attributes = this.attributes();
            Map<String, Object> other$attributes = other.attributes();
            if (this$attributes == null ? other$attributes != null : !((Object)this$attributes).equals(other$attributes)) {
                return false;
            }
            Map<String, Object> this$internalAttributes = this.internalAttributes();
            Map<String, Object> other$internalAttributes = other.internalAttributes();
            if (this$internalAttributes == null ? other$internalAttributes != null : !((Object)this$internalAttributes).equals(other$internalAttributes)) {
                return false;
            }
            String this$id = this.id();
            String other$id = other.id();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            String this$correlationId = this.correlationId();
            String other$correlationId = other.correlationId();
            if (this$correlationId == null ? other$correlationId != null : !this$correlationId.equals(other$correlationId)) {
                return false;
            }
            String this$parentCorrelationId = this.parentCorrelationId();
            String other$parentCorrelationId = other.parentCorrelationId();
            if (this$parentCorrelationId == null ? other$parentCorrelationId != null : !this$parentCorrelationId.equals(other$parentCorrelationId)) {
                return false;
            }
            HttpHeaders this$headers = this.headers();
            HttpHeaders other$headers = other.headers();
            if (this$headers == null ? other$headers != null : !this$headers.equals(other$headers)) {
                return false;
            }
            Buffer this$content = this.content();
            Buffer other$content = other.content();
            if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
                return false;
            }
            Runnable this$ackRunnable = this.ackRunnable();
            Runnable other$ackRunnable = other.ackRunnable();
            if (this$ackRunnable == null ? other$ackRunnable != null : !this$ackRunnable.equals(other$ackRunnable)) {
                return false;
            }
            Runnable this$endRunnable = this.endRunnable();
            Runnable other$endRunnable = other.endRunnable();
            if (this$endRunnable == null ? other$endRunnable != null : !this$endRunnable.equals(other$endRunnable)) {
                return false;
            }
            Map<String, String> this$tracingAttributes = this.tracingAttributes();
            Map<String, String> other$tracingAttributes = other.tracingAttributes();
            return !(this$tracingAttributes == null ? other$tracingAttributes != null : !((Object)this$tracingAttributes).equals(other$tracingAttributes));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof DefaultMessageBuilder;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $timestamp = this.timestamp();
            result = result * 59 + (int)($timestamp >>> 32 ^ $timestamp);
            long $sourceTimestamp = this.sourceTimestamp();
            result = result * 59 + (int)($sourceTimestamp >>> 32 ^ $sourceTimestamp);
            result = result * 59 + (this.error() ? 79 : 97);
            result = result * 59 + (this.ended() ? 79 : 97);
            Map<String, Object> $metadata = this.metadata();
            result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
            Map<String, Object> $attributes = this.attributes();
            result = result * 59 + ($attributes == null ? 43 : ((Object)$attributes).hashCode());
            Map<String, Object> $internalAttributes = this.internalAttributes();
            result = result * 59 + ($internalAttributes == null ? 43 : ((Object)$internalAttributes).hashCode());
            String $id = this.id();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            String $correlationId = this.correlationId();
            result = result * 59 + ($correlationId == null ? 43 : $correlationId.hashCode());
            String $parentCorrelationId = this.parentCorrelationId();
            result = result * 59 + ($parentCorrelationId == null ? 43 : $parentCorrelationId.hashCode());
            HttpHeaders $headers = this.headers();
            result = result * 59 + ($headers == null ? 43 : $headers.hashCode());
            Buffer $content = this.content();
            result = result * 59 + ($content == null ? 43 : $content.hashCode());
            Runnable $ackRunnable = this.ackRunnable();
            result = result * 59 + ($ackRunnable == null ? 43 : $ackRunnable.hashCode());
            Runnable $endRunnable = this.endRunnable();
            result = result * 59 + ($endRunnable == null ? 43 : $endRunnable.hashCode());
            Map<String, String> $tracingAttributes = this.tracingAttributes();
            result = result * 59 + ($tracingAttributes == null ? 43 : ((Object)$tracingAttributes).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "DefaultMessage.DefaultMessageBuilder(timestamp=" + this.timestamp() + ", sourceTimestamp=" + this.sourceTimestamp() + ", metadata=" + String.valueOf(this.metadata()) + ", attributes=" + String.valueOf(this.attributes()) + ", internalAttributes=" + String.valueOf(this.internalAttributes()) + ", id=" + this.id() + ", correlationId=" + this.correlationId() + ", parentCorrelationId=" + this.parentCorrelationId() + ", headers=" + String.valueOf(this.headers()) + ", content=" + String.valueOf(this.content()) + ", error=" + this.error() + ", ackRunnable=" + String.valueOf(this.ackRunnable()) + ", endRunnable=" + String.valueOf(this.endRunnable()) + ", ended=" + this.ended() + ", tracingAttributes=" + String.valueOf(this.tracingAttributes()) + ")";
        }
    }
}

