/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.reactive.api.policy;

import lombok.Generated;

public class SecurityToken {
    private String tokenType;
    private String tokenValue;
    private boolean invalid;

    public static SecurityToken none() {
        return SecurityToken.builder().tokenType(TokenType.NONE.name()).build();
    }

    public static SecurityToken forApiKey(String apiKey) {
        return SecurityToken.builder().tokenType(TokenType.API_KEY.name()).tokenValue(apiKey).build();
    }

    public static SecurityToken forMD5ApiKey(String md5ApiKey) {
        return SecurityToken.builder().tokenType(TokenType.MD5_API_KEY.name()).tokenValue(md5ApiKey).build();
    }

    public static SecurityToken forClientId(String clientId) {
        return SecurityToken.builder().tokenType(TokenType.CLIENT_ID.name()).tokenValue(clientId).build();
    }

    public static SecurityToken invalid(TokenType tokenType) {
        return SecurityToken.builder().tokenType(tokenType.name()).invalid(true).build();
    }

    public static SecurityToken forClientCertificate(String clientCertificate) {
        return SecurityToken.builder().tokenType(TokenType.CERTIFICATE.name()).tokenValue(clientCertificate).build();
    }

    @Generated
    SecurityToken(String tokenType, String tokenValue, boolean invalid) {
        this.tokenType = tokenType;
        this.tokenValue = tokenValue;
        this.invalid = invalid;
    }

    @Generated
    public static SecurityTokenBuilder builder() {
        return new SecurityTokenBuilder();
    }

    @Generated
    public String getTokenType() {
        return this.tokenType;
    }

    @Generated
    public String getTokenValue() {
        return this.tokenValue;
    }

    @Generated
    public boolean isInvalid() {
        return this.invalid;
    }

    @Generated
    public String toString() {
        return "SecurityToken(tokenType=" + this.getTokenType() + ", tokenValue=" + this.getTokenValue() + ", invalid=" + this.isInvalid() + ")";
    }

    @Generated
    public static class SecurityTokenBuilder {
        @Generated
        private String tokenType;
        @Generated
        private String tokenValue;
        @Generated
        private boolean invalid;

        @Generated
        SecurityTokenBuilder() {
        }

        @Generated
        public SecurityTokenBuilder tokenType(String tokenType) {
            this.tokenType = tokenType;
            return this;
        }

        @Generated
        public SecurityTokenBuilder tokenValue(String tokenValue) {
            this.tokenValue = tokenValue;
            return this;
        }

        @Generated
        public SecurityTokenBuilder invalid(boolean invalid) {
            this.invalid = invalid;
            return this;
        }

        @Generated
        public SecurityToken build() {
            return new SecurityToken(this.tokenType, this.tokenValue, this.invalid);
        }

        @Generated
        public String toString() {
            return "SecurityToken.SecurityTokenBuilder(tokenType=" + this.tokenType + ", tokenValue=" + this.tokenValue + ", invalid=" + this.invalid + ")";
        }
    }

    public static enum TokenType {
        CLIENT_ID,
        API_KEY,
        MD5_API_KEY,
        CERTIFICATE,
        NONE;


        public static TokenType valueOfOrNone(String value) {
            try {
                return TokenType.valueOf(value.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                return NONE;
            }
        }
    }
}

