/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.node.api.cache;

import io.gravitee.node.api.cache.CacheListener;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Maybe;
import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.schedulers.Schedulers;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.Function;

public interface Cache<K, V> {
    public String getName();

    public Collection<V> values();

    default public Flowable<V> rxValues() {
        return Flowable.fromIterable(this.values()).subscribeOn(Schedulers.io());
    }

    public Set<K> keys();

    default public Flowable<K> rxKeys() {
        return Flowable.fromIterable(this.keys()).subscribeOn(Schedulers.io());
    }

    public Set<Map.Entry<K, V>> entrySet();

    default public Flowable<Map.Entry<K, V>> rxEntrySet() {
        return Flowable.fromIterable(this.entrySet()).subscribeOn(Schedulers.io());
    }

    public int size();

    default public Single<Integer> rxSize() {
        return Single.fromCallable(this::size).subscribeOn(Schedulers.io());
    }

    public boolean isEmpty();

    default public Single<Boolean> rxIsEmpty() {
        return Single.fromCallable(this::isEmpty).subscribeOn(Schedulers.io());
    }

    public boolean containsKey(K var1);

    default public Single<Boolean> rxContainsKey(K key) {
        return Single.fromCallable(() -> this.containsKey(key)).subscribeOn(Schedulers.io());
    }

    public V get(K var1);

    default public Maybe<V> rxGet(K key) {
        return Maybe.fromCallable(() -> this.get(key)).subscribeOn(Schedulers.io());
    }

    public V put(K var1, V var2);

    default public Maybe<V> rxPut(K key, V value) {
        return Maybe.fromCallable(() -> this.put(key, value)).subscribeOn(Schedulers.io());
    }

    public V put(K var1, V var2, long var3, TimeUnit var5);

    default public Maybe<V> rxPut(K key, V value, long ttl, TimeUnit ttlUnit) {
        return Maybe.fromCallable(() -> this.put(key, value, ttl, ttlUnit)).subscribeOn(Schedulers.io());
    }

    public void putAll(Map<? extends K, ? extends V> var1);

    default public Completable rxPutAll(Map<? extends K, ? extends V> m) {
        return Completable.fromRunnable(() -> this.putAll(m)).subscribeOn(Schedulers.io());
    }

    public V computeIfAbsent(K var1, Function<? super K, ? extends V> var2);

    default public Maybe<V> rxComputeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        return Maybe.fromCallable(() -> this.computeIfAbsent(key, mappingFunction)).subscribeOn(Schedulers.io());
    }

    public V computeIfPresent(K var1, BiFunction<? super K, ? super V, ? extends V> var2);

    default public Maybe<V> rxComputeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        return Maybe.fromCallable(() -> this.computeIfPresent(key, remappingFunction)).subscribeOn(Schedulers.io());
    }

    public V compute(K var1, BiFunction<? super K, ? super V, ? extends V> var2);

    default public Maybe<V> rxCompute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        return Maybe.fromCallable(() -> this.compute(key, remappingFunction)).subscribeOn(Schedulers.io());
    }

    public V evict(K var1);

    default public Maybe<V> rxEvict(K key) {
        return Maybe.fromCallable(() -> this.evict(key)).subscribeOn(Schedulers.io());
    }

    public void clear();

    default public Completable rxClear() {
        return Completable.fromRunnable(this::clear).subscribeOn(Schedulers.io());
    }

    public String addCacheListener(CacheListener<K, V> var1);

    default public Single<String> rxAddCacheListener(CacheListener<K, V> listener) {
        return Single.fromCallable(() -> this.addCacheListener(listener)).subscribeOn(Schedulers.io());
    }

    public boolean removeCacheListener(String var1);

    default public Single<Boolean> rxRemoveCacheListener(String listenerCacheId) {
        return Single.fromCallable(() -> this.removeCacheListener(listenerCacheId)).subscribeOn(Schedulers.io());
    }
}

