/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.node.api.certificate;

import io.gravitee.common.util.KeyStoreUtils;
import java.security.KeyStore;
import java.util.Objects;

public interface KeyStoreEvent {
    public String loaderId();

    public record UnloadEvent(String loaderId) implements KeyStoreEvent
    {
        public UnloadEvent {
            Objects.requireNonNull(loaderId);
        }
    }

    public record LoadEvent(String loaderId, KeyStore keyStore, String password) implements KeyStoreEvent
    {
        public LoadEvent {
            Objects.requireNonNull(loaderId);
            Objects.requireNonNull(keyStore);
            Objects.requireNonNull(password);
        }

        public KeyStore.PasswordProtection passwordAsProtection() {
            return new KeyStore.PasswordProtection(KeyStoreUtils.passwordToCharArray((String)this.password));
        }
    }
}

