/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.node.api.opentelemetry.http;

import io.gravitee.node.api.opentelemetry.http.ObservableHttpRequest;
import io.vertx.core.MultiMap;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.RequestOptions;
import io.vertx.core.http.impl.headers.HeadersMultiMap;
import io.vertx.core.net.SocketAddress;
import lombok.Generated;
import lombok.NonNull;

public class ObservableHttpClientRequest
implements ObservableHttpRequest {
    @NonNull
    private final RequestOptions requestOptions;
    private HttpClientRequest httpClientRequest;

    public int id() {
        return 0;
    }

    public String uri() {
        return this.requestOptions.getURI();
    }

    public String absoluteURI() {
        return (Boolean.TRUE.equals(this.requestOptions.isSsl()) ? "https://" : "http://") + this.requestOptions.getHost() + ":" + this.requestOptions.getPort() + this.requestOptions.getURI();
    }

    public HttpMethod method() {
        return this.requestOptions.getMethod();
    }

    public MultiMap headers() {
        MultiMap headers = null;
        if (this.httpClientRequest != null) {
            headers = this.httpClientRequest.headers();
        }
        if (headers == null) {
            headers = this.requestOptions.getHeaders();
        }
        if (headers == null) {
            return HeadersMultiMap.headers();
        }
        return headers;
    }

    public SocketAddress remoteAddress() {
        return this.requestOptions.getServer();
    }

    public String traceOperation() {
        String traceOperation = null;
        if (this.httpClientRequest != null) {
            traceOperation = this.httpClientRequest.traceOperation();
        }
        if (traceOperation == null) {
            traceOperation = this.requestOptions.getTraceOperation();
        }
        return traceOperation;
    }

    @Generated
    public ObservableHttpClientRequest(@NonNull RequestOptions requestOptions) {
        if (requestOptions == null) {
            throw new NullPointerException("requestOptions is marked non-null but is null");
        }
        this.requestOptions = requestOptions;
    }

    @NonNull
    @Generated
    public RequestOptions requestOptions() {
        return this.requestOptions;
    }

    @Generated
    public HttpClientRequest httpClientRequest() {
        return this.httpClientRequest;
    }

    @Generated
    public ObservableHttpClientRequest httpClientRequest(HttpClientRequest httpClientRequest) {
        this.httpClientRequest = httpClientRequest;
        return this;
    }
}

