/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.node.api.server;

import io.gravitee.node.api.server.Server;
import io.gravitee.node.api.server.ServerManager;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class DefaultServerManager
implements ServerManager {
    private final Map<String, Server<?>> servers = new LinkedHashMap();

    @Override
    public void register(Server<?> server) {
        this.servers.put(server.id(), server);
    }

    @Override
    public void unregister(Server<?> server) {
        this.servers.remove(server.id());
    }

    @Override
    public List<Server<?>> servers() {
        return List.copyOf(this.servers.values());
    }

    @Override
    public <T extends Server<?>> List<T> servers(Class<T> serverClazz) {
        return this.servers.values().stream().filter(server -> serverClazz.isAssignableFrom(server.getClass())).map(serverClazz::cast).toList();
    }

    @Override
    public Server<?> server(String id) {
        return this.servers.get(id);
    }
}

