/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.reporter.api.health;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import io.gravitee.reporter.api.AbstractReportable;
import io.gravitee.reporter.api.common.Request;
import io.gravitee.reporter.api.common.Response;
import io.gravitee.reporter.api.health.Step;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

@JsonDeserialize(builder=EndpointStatusBuilderImpl.class)
public class EndpointStatus
extends AbstractReportable {
    private final String id;
    private final String api;
    private final String apiName;
    private final String endpoint;
    private int state;
    private boolean available = true;
    private final boolean success;
    private long responseTime;
    private final List<Step> steps;
    private boolean transition = false;

    private EndpointStatus(long timestamp, String api, String endpoint, List<Step> steps, String apiName) {
        super(timestamp);
        this.id = io.gravitee.common.utils.UUID.toString((UUID)io.gravitee.common.utils.UUID.random());
        this.api = api;
        this.endpoint = endpoint;
        this.steps = steps;
        this.success = steps.stream().allMatch(Step::isSuccess);
        this.apiName = apiName;
    }

    public String getId() {
        return this.id;
    }

    public String getApi() {
        return this.api;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public int getState() {
        return this.state;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public List<Step> getSteps() {
        return this.steps;
    }

    public void setState(int state) {
        this.state = state;
    }

    public boolean isAvailable() {
        return this.available;
    }

    public void setAvailable(boolean available) {
        this.available = available;
    }

    public long getResponseTime() {
        return this.responseTime;
    }

    public void setResponseTime(long responseTime) {
        this.responseTime = responseTime;
    }

    public boolean isTransition() {
        return this.transition;
    }

    public void setTransition(boolean transition) {
        this.transition = transition;
    }

    public String getApiName() {
        return this.apiName;
    }

    public static Builder forEndpoint(String api, String endpoint) {
        return EndpointStatus.forEndpoint(api, null, endpoint);
    }

    public static Builder forEndpoint(String api, String apiName, String endpoint) {
        return new Builder(api, apiName, endpoint);
    }

    public static StepBuilder forStep(String step) {
        return new StepBuilder(step);
    }

    protected EndpointStatus(EndpointStatusBuilder<?, ?> b) {
        super(b);
        this.id = b.id;
        this.api = b.api;
        this.apiName = b.apiName;
        this.endpoint = b.endpoint;
        this.state = b.state;
        this.available = b.available;
        this.success = b.success;
        this.responseTime = b.responseTime;
        this.steps = b.steps;
        this.transition = b.transition;
    }

    public static EndpointStatusBuilder<?, ?> builder() {
        return new EndpointStatusBuilderImpl();
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    static final class EndpointStatusBuilderImpl
    extends EndpointStatusBuilder<EndpointStatus, EndpointStatusBuilderImpl> {
        private EndpointStatusBuilderImpl() {
        }

        @Override
        protected EndpointStatusBuilderImpl self() {
            return this;
        }

        @Override
        public EndpointStatus build() {
            return new EndpointStatus(this);
        }
    }

    public static abstract class EndpointStatusBuilder<C extends EndpointStatus, B extends EndpointStatusBuilder<C, B>>
    extends AbstractReportable.AbstractReportableBuilder<C, B> {
        private String id;
        private String api;
        private String apiName;
        private String endpoint;
        private int state;
        private boolean available;
        private boolean success;
        private long responseTime;
        private List<Step> steps;
        private boolean transition;

        public B id(String id) {
            this.id = id;
            return (B)this.self();
        }

        public B api(String api) {
            this.api = api;
            return (B)this.self();
        }

        public B apiName(String apiName) {
            this.apiName = apiName;
            return (B)this.self();
        }

        public B endpoint(String endpoint) {
            this.endpoint = endpoint;
            return (B)this.self();
        }

        public B state(int state) {
            this.state = state;
            return (B)this.self();
        }

        public B available(boolean available) {
            this.available = available;
            return (B)this.self();
        }

        public B success(boolean success) {
            this.success = success;
            return (B)this.self();
        }

        public B responseTime(long responseTime) {
            this.responseTime = responseTime;
            return (B)this.self();
        }

        public B steps(List<Step> steps) {
            this.steps = steps;
            return (B)this.self();
        }

        public B transition(boolean transition) {
            this.transition = transition;
            return (B)this.self();
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "EndpointStatus.EndpointStatusBuilder(super=" + super.toString() + ", id=" + this.id + ", api=" + this.api + ", apiName=" + this.apiName + ", endpoint=" + this.endpoint + ", state=" + this.state + ", available=" + this.available + ", success=" + this.success + ", responseTime=" + this.responseTime + ", steps=" + this.steps + ", transition=" + this.transition + ")";
        }
    }

    public static class StepBuilder {
        private final String step;
        private boolean success = true;
        private String message;
        private long responseTime;
        private Request request;
        private Response response;

        private StepBuilder(String step) {
            this.step = step;
        }

        public StepBuilder success() {
            this.success = true;
            return this;
        }

        public StepBuilder fail(String message) {
            this.success = false;
            this.message = message;
            return this;
        }

        public StepBuilder responseTime(long responseTime) {
            this.responseTime = responseTime;
            return this;
        }

        public StepBuilder request(Request request) {
            this.request = request;
            return this;
        }

        public StepBuilder response(Response response) {
            this.response = response;
            return this;
        }

        public boolean isSuccess() {
            return this.success;
        }

        public Step build() {
            Step result = new Step(this.step);
            result.setSuccess(this.success);
            result.setRequest(this.request);
            result.setResponse(this.response);
            result.setMessage(this.message);
            result.setResponseTime(this.responseTime);
            return result;
        }
    }

    public static class Builder {
        private final String api;
        private final String endpoint;
        private long timestamp;
        private List<Step> steps = new ArrayList<Step>();
        private String apiName;

        private Builder(String api, String apiName, String endpoint) {
            this.api = api;
            this.endpoint = endpoint;
            this.apiName = apiName;
        }

        public Builder on(long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public Builder step(Step step) {
            this.steps.add(step);
            return this;
        }

        public Builder apiName(String apiName) {
            this.apiName = apiName;
            return this;
        }

        public EndpointStatus build() {
            return new EndpointStatus(this.timestamp, this.api, this.endpoint, this.steps, this.apiName);
        }
    }
}

