/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.reporter.api.http;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import io.gravitee.common.http.HttpMethod;
import io.gravitee.reporter.api.AbstractReportable;
import io.gravitee.reporter.api.http.SecurityType;
import io.gravitee.reporter.api.log.Log;
import java.util.HashMap;
import java.util.Map;

@JsonDeserialize(builder=MetricsBuilderImpl.class)
public class Metrics
extends AbstractReportable {
    private long proxyResponseTimeMs = 0L;
    private long proxyLatencyMs = 0L;
    private long apiResponseTimeMs = 0L;
    private String requestId;
    private String api;
    private String apiName;
    private String application;
    private String transactionId;
    private String clientIdentifier;
    private String tenant;
    private String message;
    private String plan;
    private String localAddress;
    private String remoteAddress;
    private HttpMethod httpMethod;
    private String host;
    private String uri;
    private long requestContentLength = 0L;
    private long responseContentLength = 0L;
    private int status;
    private String endpoint;
    private Log log;
    private String path;
    private String mappedPath;
    private String userAgent;
    private String user;
    private SecurityType securityType;
    private String securityToken;
    private String errorKey;
    private String subscription;
    private String zone;
    private Map<String, String> customMetrics = new HashMap<String, String>();

    protected Metrics(long timestamp) {
        super(timestamp);
    }

    public static Builder on(long timestamp) {
        return new Builder(timestamp);
    }

    public void addCustomMetric(String key, String value) {
        this.customMetrics.put(key, value);
    }

    protected Metrics(MetricsBuilder<?, ?> b) {
        super(b);
        this.proxyResponseTimeMs = b.proxyResponseTimeMs;
        this.proxyLatencyMs = b.proxyLatencyMs;
        this.apiResponseTimeMs = b.apiResponseTimeMs;
        this.requestId = b.requestId;
        this.api = b.api;
        this.apiName = b.apiName;
        this.application = b.application;
        this.transactionId = b.transactionId;
        this.clientIdentifier = b.clientIdentifier;
        this.tenant = b.tenant;
        this.message = b.message;
        this.plan = b.plan;
        this.localAddress = b.localAddress;
        this.remoteAddress = b.remoteAddress;
        this.httpMethod = b.httpMethod;
        this.host = b.host;
        this.uri = b.uri;
        this.requestContentLength = b.requestContentLength;
        this.responseContentLength = b.responseContentLength;
        this.status = b.status;
        this.endpoint = b.endpoint;
        this.log = b.log;
        this.path = b.path;
        this.mappedPath = b.mappedPath;
        this.userAgent = b.userAgent;
        this.user = b.user;
        this.securityType = b.securityType;
        this.securityToken = b.securityToken;
        this.errorKey = b.errorKey;
        this.subscription = b.subscription;
        this.zone = b.zone;
        this.customMetrics = b.customMetrics;
    }

    public static MetricsBuilder<?, ?> builder() {
        return new MetricsBuilderImpl();
    }

    public long getProxyResponseTimeMs() {
        return this.proxyResponseTimeMs;
    }

    public long getProxyLatencyMs() {
        return this.proxyLatencyMs;
    }

    public long getApiResponseTimeMs() {
        return this.apiResponseTimeMs;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public String getApi() {
        return this.api;
    }

    public String getApiName() {
        return this.apiName;
    }

    public String getApplication() {
        return this.application;
    }

    public String getTransactionId() {
        return this.transactionId;
    }

    public String getClientIdentifier() {
        return this.clientIdentifier;
    }

    public String getTenant() {
        return this.tenant;
    }

    public String getMessage() {
        return this.message;
    }

    public String getPlan() {
        return this.plan;
    }

    public String getLocalAddress() {
        return this.localAddress;
    }

    public String getRemoteAddress() {
        return this.remoteAddress;
    }

    public HttpMethod getHttpMethod() {
        return this.httpMethod;
    }

    public String getHost() {
        return this.host;
    }

    public String getUri() {
        return this.uri;
    }

    public long getRequestContentLength() {
        return this.requestContentLength;
    }

    public long getResponseContentLength() {
        return this.responseContentLength;
    }

    public int getStatus() {
        return this.status;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public Log getLog() {
        return this.log;
    }

    public String getPath() {
        return this.path;
    }

    public String getMappedPath() {
        return this.mappedPath;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public String getUser() {
        return this.user;
    }

    public SecurityType getSecurityType() {
        return this.securityType;
    }

    public String getSecurityToken() {
        return this.securityToken;
    }

    public String getErrorKey() {
        return this.errorKey;
    }

    public String getSubscription() {
        return this.subscription;
    }

    public String getZone() {
        return this.zone;
    }

    public Map<String, String> getCustomMetrics() {
        return this.customMetrics;
    }

    public void setProxyResponseTimeMs(long proxyResponseTimeMs) {
        this.proxyResponseTimeMs = proxyResponseTimeMs;
    }

    public void setProxyLatencyMs(long proxyLatencyMs) {
        this.proxyLatencyMs = proxyLatencyMs;
    }

    public void setApiResponseTimeMs(long apiResponseTimeMs) {
        this.apiResponseTimeMs = apiResponseTimeMs;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public void setApi(String api) {
        this.api = api;
    }

    public void setApiName(String apiName) {
        this.apiName = apiName;
    }

    public void setApplication(String application) {
        this.application = application;
    }

    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    public void setClientIdentifier(String clientIdentifier) {
        this.clientIdentifier = clientIdentifier;
    }

    public void setTenant(String tenant) {
        this.tenant = tenant;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setPlan(String plan) {
        this.plan = plan;
    }

    public void setLocalAddress(String localAddress) {
        this.localAddress = localAddress;
    }

    public void setRemoteAddress(String remoteAddress) {
        this.remoteAddress = remoteAddress;
    }

    public void setHttpMethod(HttpMethod httpMethod) {
        this.httpMethod = httpMethod;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public void setRequestContentLength(long requestContentLength) {
        this.requestContentLength = requestContentLength;
    }

    public void setResponseContentLength(long responseContentLength) {
        this.responseContentLength = responseContentLength;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public void setLog(Log log) {
        this.log = log;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMappedPath(String mappedPath) {
        this.mappedPath = mappedPath;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setSecurityType(SecurityType securityType) {
        this.securityType = securityType;
    }

    public void setSecurityToken(String securityToken) {
        this.securityToken = securityToken;
    }

    public void setErrorKey(String errorKey) {
        this.errorKey = errorKey;
    }

    public void setSubscription(String subscription) {
        this.subscription = subscription;
    }

    public void setZone(String zone) {
        this.zone = zone;
    }

    public void setCustomMetrics(Map<String, String> customMetrics) {
        this.customMetrics = customMetrics;
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    static final class MetricsBuilderImpl
    extends MetricsBuilder<Metrics, MetricsBuilderImpl> {
        private MetricsBuilderImpl() {
        }

        @Override
        protected MetricsBuilderImpl self() {
            return this;
        }

        @Override
        public Metrics build() {
            return new Metrics(this);
        }
    }

    public static abstract class MetricsBuilder<C extends Metrics, B extends MetricsBuilder<C, B>>
    extends AbstractReportable.AbstractReportableBuilder<C, B> {
        private long proxyResponseTimeMs;
        private long proxyLatencyMs;
        private long apiResponseTimeMs;
        private String requestId;
        private String api;
        private String apiName;
        private String application;
        private String transactionId;
        private String clientIdentifier;
        private String tenant;
        private String message;
        private String plan;
        private String localAddress;
        private String remoteAddress;
        private HttpMethod httpMethod;
        private String host;
        private String uri;
        private long requestContentLength;
        private long responseContentLength;
        private int status;
        private String endpoint;
        private Log log;
        private String path;
        private String mappedPath;
        private String userAgent;
        private String user;
        private SecurityType securityType;
        private String securityToken;
        private String errorKey;
        private String subscription;
        private String zone;
        private Map<String, String> customMetrics;

        public B proxyResponseTimeMs(long proxyResponseTimeMs) {
            this.proxyResponseTimeMs = proxyResponseTimeMs;
            return (B)this.self();
        }

        public B proxyLatencyMs(long proxyLatencyMs) {
            this.proxyLatencyMs = proxyLatencyMs;
            return (B)this.self();
        }

        public B apiResponseTimeMs(long apiResponseTimeMs) {
            this.apiResponseTimeMs = apiResponseTimeMs;
            return (B)this.self();
        }

        public B requestId(String requestId) {
            this.requestId = requestId;
            return (B)this.self();
        }

        public B api(String api) {
            this.api = api;
            return (B)this.self();
        }

        public B apiName(String apiName) {
            this.apiName = apiName;
            return (B)this.self();
        }

        public B application(String application) {
            this.application = application;
            return (B)this.self();
        }

        public B transactionId(String transactionId) {
            this.transactionId = transactionId;
            return (B)this.self();
        }

        public B clientIdentifier(String clientIdentifier) {
            this.clientIdentifier = clientIdentifier;
            return (B)this.self();
        }

        public B tenant(String tenant) {
            this.tenant = tenant;
            return (B)this.self();
        }

        public B message(String message) {
            this.message = message;
            return (B)this.self();
        }

        public B plan(String plan) {
            this.plan = plan;
            return (B)this.self();
        }

        public B localAddress(String localAddress) {
            this.localAddress = localAddress;
            return (B)this.self();
        }

        public B remoteAddress(String remoteAddress) {
            this.remoteAddress = remoteAddress;
            return (B)this.self();
        }

        public B httpMethod(HttpMethod httpMethod) {
            this.httpMethod = httpMethod;
            return (B)this.self();
        }

        public B host(String host) {
            this.host = host;
            return (B)this.self();
        }

        public B uri(String uri) {
            this.uri = uri;
            return (B)this.self();
        }

        public B requestContentLength(long requestContentLength) {
            this.requestContentLength = requestContentLength;
            return (B)this.self();
        }

        public B responseContentLength(long responseContentLength) {
            this.responseContentLength = responseContentLength;
            return (B)this.self();
        }

        public B status(int status) {
            this.status = status;
            return (B)this.self();
        }

        public B endpoint(String endpoint) {
            this.endpoint = endpoint;
            return (B)this.self();
        }

        public B log(Log log) {
            this.log = log;
            return (B)this.self();
        }

        public B path(String path) {
            this.path = path;
            return (B)this.self();
        }

        public B mappedPath(String mappedPath) {
            this.mappedPath = mappedPath;
            return (B)this.self();
        }

        public B userAgent(String userAgent) {
            this.userAgent = userAgent;
            return (B)this.self();
        }

        public B user(String user) {
            this.user = user;
            return (B)this.self();
        }

        public B securityType(SecurityType securityType) {
            this.securityType = securityType;
            return (B)this.self();
        }

        public B securityToken(String securityToken) {
            this.securityToken = securityToken;
            return (B)this.self();
        }

        public B errorKey(String errorKey) {
            this.errorKey = errorKey;
            return (B)this.self();
        }

        public B subscription(String subscription) {
            this.subscription = subscription;
            return (B)this.self();
        }

        public B zone(String zone) {
            this.zone = zone;
            return (B)this.self();
        }

        public B customMetrics(Map<String, String> customMetrics) {
            this.customMetrics = customMetrics;
            return (B)this.self();
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "Metrics.MetricsBuilder(super=" + super.toString() + ", proxyResponseTimeMs=" + this.proxyResponseTimeMs + ", proxyLatencyMs=" + this.proxyLatencyMs + ", apiResponseTimeMs=" + this.apiResponseTimeMs + ", requestId=" + this.requestId + ", api=" + this.api + ", apiName=" + this.apiName + ", application=" + this.application + ", transactionId=" + this.transactionId + ", clientIdentifier=" + this.clientIdentifier + ", tenant=" + this.tenant + ", message=" + this.message + ", plan=" + this.plan + ", localAddress=" + this.localAddress + ", remoteAddress=" + this.remoteAddress + ", httpMethod=" + this.httpMethod + ", host=" + this.host + ", uri=" + this.uri + ", requestContentLength=" + this.requestContentLength + ", responseContentLength=" + this.responseContentLength + ", status=" + this.status + ", endpoint=" + this.endpoint + ", log=" + this.log + ", path=" + this.path + ", mappedPath=" + this.mappedPath + ", userAgent=" + this.userAgent + ", user=" + this.user + ", securityType=" + this.securityType + ", securityToken=" + this.securityToken + ", errorKey=" + this.errorKey + ", subscription=" + this.subscription + ", zone=" + this.zone + ", customMetrics=" + this.customMetrics + ")";
        }
    }

    public static class Builder {
        private final long timestamp;

        private Builder(long timestamp) {
            this.timestamp = timestamp;
        }

        public Metrics build() {
            return new Metrics(this.timestamp);
        }
    }
}

