/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.reporter.api.monitor;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import io.gravitee.reporter.api.AbstractReportable;
import io.gravitee.reporter.api.monitor.JvmInfo;
import io.gravitee.reporter.api.monitor.OsInfo;
import io.gravitee.reporter.api.monitor.ProcessInfo;

@JsonDeserialize(builder=MonitorBuilderImpl.class)
public class Monitor
extends AbstractReportable {
    JvmInfo jvm;
    OsInfo os;
    ProcessInfo process;

    public Monitor(long timestamp) {
        super(timestamp);
    }

    public JvmInfo getJvm() {
        return this.jvm;
    }

    public OsInfo getOs() {
        return this.os;
    }

    public ProcessInfo getProcess() {
        return this.process;
    }

    public static Builder on(String gateway) {
        return new Builder();
    }

    protected Monitor(MonitorBuilder<?, ?> b) {
        super(b);
        this.jvm = b.jvm;
        this.os = b.os;
        this.process = b.process;
    }

    public static MonitorBuilder<?, ?> builder() {
        return new MonitorBuilderImpl();
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    static final class MonitorBuilderImpl
    extends MonitorBuilder<Monitor, MonitorBuilderImpl> {
        private MonitorBuilderImpl() {
        }

        @Override
        protected MonitorBuilderImpl self() {
            return this;
        }

        @Override
        public Monitor build() {
            return new Monitor(this);
        }
    }

    public static abstract class MonitorBuilder<C extends Monitor, B extends MonitorBuilder<C, B>>
    extends AbstractReportable.AbstractReportableBuilder<C, B> {
        private JvmInfo jvm;
        private OsInfo os;
        private ProcessInfo process;

        public B jvm(JvmInfo jvm) {
            this.jvm = jvm;
            return (B)this.self();
        }

        public B os(OsInfo os) {
            this.os = os;
            return (B)this.self();
        }

        public B process(ProcessInfo process) {
            this.process = process;
            return (B)this.self();
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "Monitor.MonitorBuilder(super=" + super.toString() + ", jvm=" + this.jvm + ", os=" + this.os + ", process=" + this.process + ")";
        }
    }

    public static class Builder {
        private long timestamp;
        private OsInfo os;
        private JvmInfo jvm;
        private ProcessInfo process;

        public Builder at(long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public Builder os(OsInfo os) {
            this.os = os;
            return this;
        }

        public Builder jvm(JvmInfo jvm) {
            this.jvm = jvm;
            return this;
        }

        public Builder process(ProcessInfo process) {
            this.process = process;
            return this;
        }

        public Monitor build() {
            Monitor metrics = new Monitor(this.timestamp);
            metrics.os = this.os;
            metrics.jvm = this.jvm;
            metrics.process = this.process;
            return metrics;
        }
    }
}

