/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.policy.transformheaders;

import io.gravitee.el.TemplateEngine;
import io.gravitee.gateway.api.buffer.Buffer;
import io.gravitee.gateway.api.http.HttpHeaders;
import io.gravitee.gateway.reactive.api.ExecutionFailure;
import io.gravitee.gateway.reactive.api.context.http.HttpMessageExecutionContext;
import io.gravitee.gateway.reactive.api.context.http.HttpPlainExecutionContext;
import io.gravitee.gateway.reactive.api.context.kafka.KafkaMessageExecutionContext;
import io.gravitee.gateway.reactive.api.message.Message;
import io.gravitee.gateway.reactive.api.message.kafka.KafkaMessage;
import io.gravitee.gateway.reactive.api.policy.http.HttpPolicy;
import io.gravitee.gateway.reactive.api.policy.kafka.KafkaPolicy;
import io.gravitee.policy.transformheaders.configuration.HttpHeader;
import io.gravitee.policy.transformheaders.configuration.TransformHeadersPolicyConfiguration;
import io.gravitee.policy.transformheaders.v3.TransformHeadersPolicyV3;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.CompletableSource;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Maybe;
import io.reactivex.rxjava3.core.MaybeSource;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.function.BiFunction;
import org.apache.kafka.common.protocol.Errors;

public class TransformHeadersPolicy
extends TransformHeadersPolicyV3
implements HttpPolicy,
KafkaPolicy {
    private static final String TRANSFORM_HEADERS_FAILURE = "TRANSFORM_HEADERS_FAILURE";

    public TransformHeadersPolicy(TransformHeadersPolicyConfiguration configuration) {
        super(configuration);
    }

    public String id() {
        return "transform-headers";
    }

    public Completable onRequest(HttpPlainExecutionContext ctx) {
        return Completable.defer(() -> this.transform(ctx, ctx.request().headers()));
    }

    public Completable onResponse(HttpPlainExecutionContext ctx) {
        return Completable.defer(() -> this.transform(ctx, ctx.response().headers()));
    }

    private Completable transform(HttpPlainExecutionContext ctx, HttpHeaders httpHeaders) {
        return this.transformHeaders(ctx.getTemplateEngine(), httpHeaders).onErrorResumeWith((CompletableSource)ctx.interruptWith(new ExecutionFailure(500).key(TRANSFORM_HEADERS_FAILURE).message("Unable to apply headers transformation")));
    }

    public Completable onMessageRequest(HttpMessageExecutionContext ctx) {
        return ctx.request().onMessage(message -> this.transformMessageHeaders(ctx, (Message)message));
    }

    public Completable onMessageResponse(HttpMessageExecutionContext ctx) {
        return ctx.response().onMessage(message -> this.transformMessageHeaders(ctx, (Message)message));
    }

    private Maybe<Message> transformMessageHeaders(HttpMessageExecutionContext ctx, Message message) {
        return this.transformHeaders(ctx.getTemplateEngine(message), message.headers()).andThen((MaybeSource)Maybe.just((Object)message)).onErrorResumeWith((MaybeSource)ctx.interruptMessageWith(new ExecutionFailure(500).key(TRANSFORM_HEADERS_FAILURE).message("Unable to apply headers transformation on message")));
    }

    private Completable transformHeaders(TemplateEngine templateEngine, HttpHeaders httpHeaders) {
        return this.addHeaders(templateEngine, httpHeaders).andThen((CompletableSource)this.appendHeaders(templateEngine, httpHeaders)).andThen((CompletableSource)Completable.fromRunnable(() -> this.removeHeaders(httpHeaders)));
    }

    private Completable addHeaders(TemplateEngine templateEngine, HttpHeaders httpHeaders) {
        return this.updateHeaders(this.configuration::getAddHeaders, templateEngine, (key, value) -> Optional.ofNullable(httpHeaders).map(h -> h.set((CharSequence)key, (CharSequence)value)).orElse(null));
    }

    private Completable appendHeaders(TemplateEngine templateEngine, HttpHeaders httpHeaders) {
        return this.updateHeaders(this.configuration::getAppendHeaders, templateEngine, (key, value) -> Optional.ofNullable(httpHeaders).map(h -> h.add((CharSequence)key, (CharSequence)value)).orElse(null));
    }

    public Completable onMessageRequest(KafkaMessageExecutionContext ctx) {
        return ctx.request().onMessage(message -> this.transformKafkaMessageHeaders(ctx, (KafkaMessage)message));
    }

    public Completable onMessageResponse(KafkaMessageExecutionContext ctx) {
        return ctx.response().onMessage(message -> this.transformKafkaMessageHeaders(ctx, (KafkaMessage)message));
    }

    private Maybe<KafkaMessage> transformKafkaMessageHeaders(KafkaMessageExecutionContext ctx, KafkaMessage kafkaMessage) {
        return this.transformHeaders(ctx.getTemplateEngine(kafkaMessage), kafkaMessage).onErrorResumeWith((CompletableSource)ctx.executionContext().interruptWith(Errors.INVALID_RECORD)).andThen((MaybeSource)Maybe.just((Object)kafkaMessage));
    }

    private Completable transformHeaders(TemplateEngine templateEngine, KafkaMessage message) {
        return this.addHeaders(templateEngine, message).andThen((CompletableSource)Completable.fromRunnable(() -> this.removeHeaders(message)));
    }

    private Completable addHeaders(TemplateEngine templateEngine, KafkaMessage message) {
        return this.updateHeaders(this.configuration::getAddHeaders, templateEngine, (key, value) -> message.putRecordHeader(key, Buffer.buffer((String)value)));
    }

    private Completable updateHeaders(Callable<List<HttpHeader>> configurationHeaders, TemplateEngine templateEngine, BiFunction<String, String, ?> updateHeaders) {
        return Maybe.fromCallable(configurationHeaders).flatMapPublisher(Flowable::fromIterable).filter(httpHeader -> httpHeader.getName() != null && !httpHeader.getName().trim().isEmpty() && httpHeader.getValue() != null).flatMapCompletable(httpHeader -> templateEngine.eval(httpHeader.getValue(), String.class).doOnSuccess(newValue -> updateHeaders.apply(httpHeader.getName(), (String)newValue)).ignoreElement());
    }
}

