/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.el.spel.function.xml;

import io.gravitee.el.spel.function.xml.DocumentBuilderFactoryUtils;
import io.gravitee.el.spel.function.xml.XPathEvaluationType;
import io.gravitee.el.spel.function.xml.XPathException;
import io.gravitee.el.spel.function.xml.XPathExpression;
import io.gravitee.el.spel.function.xml.XPathExpressionFactory;
import io.gravitee.el.spel.function.xml.XmlPayloadConverter;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.springframework.util.Assert;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class XPathFunction {
    public static final String STRING = "string";
    public static final String BOOLEAN = "boolean";
    public static final String NUMBER = "number";
    public static final String NODE = "node";
    public static final String NODE_LIST = "node_list";
    public static final String DOCUMENT_LIST = "document_list";
    private static final List<String> RESULT_TYPES = Arrays.asList("string", "boolean", "number", "node", "node_list", "document_list");
    private static final XmlPayloadConverter CONVERTER = new XmlPayloadConverter();
    private static final DocumentBuilderFactory DOCUMENT_BUILDER_FACTORY = DocumentBuilderFactoryUtils.newInstance();

    private XPathFunction() {
    }

    public static <T> T evaluate(Object object, String xpath, Object ... resultArg) {
        Object resultType = null;
        if (resultArg != null && resultArg.length > 0) {
            Assert.isTrue((resultArg.length == 1 ? 1 : 0) != 0, (String)"'resultArg' can contains only one element.");
            Assert.noNullElements((Object[])resultArg, (String)"'resultArg' can't contains 'null' elements.");
            resultType = resultArg[0];
        }
        XPathExpression expression = XPathExpressionFactory.createXPathExpression(xpath);
        if (resultType == null) {
            try {
                DocumentBuilder documentBuilder = DOCUMENT_BUILDER_FACTORY.newDocumentBuilder();
                Document document = documentBuilder.parse(new InputSource(new StringReader(object.toString())));
                return (T)expression.evaluateAsString(document);
            }
            catch (IOException | ParserConfigurationException | SAXException e) {
                throw new XPathException("Unable to parse 'object' as XML document.", e);
            }
        }
        if (resultType instanceof String && RESULT_TYPES.contains(resultType)) {
            Node node = CONVERTER.convertToNode(object);
            String resType = (String)resultType;
            if (DOCUMENT_LIST.equals(resType)) {
                List nodeList = (List)XPathEvaluationType.NODE_LIST_RESULT.evaluateXPath(expression, node);
                try {
                    DocumentBuilder documentBuilder = DOCUMENT_BUILDER_FACTORY.newDocumentBuilder();
                    ArrayList<Document> documents = new ArrayList<Document>(nodeList.size());
                    for (Node n : nodeList) {
                        Document document = documentBuilder.newDocument();
                        document.appendChild(document.importNode(n, true));
                        documents.add(document);
                    }
                    return (T)documents;
                }
                catch (ParserConfigurationException e) {
                    throw new XPathException("Unable to create 'documentBuilder'.", e);
                }
            }
            XPathEvaluationType evaluationType = XPathEvaluationType.valueOf(resType.toUpperCase() + "_RESULT");
            return (T)evaluationType.evaluateXPath(expression, node);
        }
        throw new IllegalArgumentException("'resultArg[0]' can be an instance of 'NodeMapper<?>' or one of supported String constants: " + String.valueOf(RESULT_TYPES));
    }

    static {
        DOCUMENT_BUILDER_FACTORY.setNamespaceAware(false);
    }
}

