/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.el.spel.function.xml;

import io.gravitee.el.spel.function.xml.DocumentBuilderFactoryUtils;
import io.gravitee.el.spel.function.xml.XPathException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class XmlPayloadConverter {
    private final DocumentBuilderFactory documentBuilderFactory;

    public XmlPayloadConverter() {
        this(DocumentBuilderFactoryUtils.newInstance());
        this.documentBuilderFactory.setNamespaceAware(true);
    }

    public XmlPayloadConverter(DocumentBuilderFactory documentBuilderFactory) {
        this.documentBuilderFactory = documentBuilderFactory;
    }

    public Document convertToDocument(Object object) {
        try {
            if (object instanceof Document) {
                return (Document)object;
            }
            if (object instanceof Node) {
                return this.nodeToDocument((Node)object);
            }
            if (object instanceof DOMSource) {
                Node node = ((DOMSource)object).getNode();
                return this.nodeToDocument(node);
            }
            if (object instanceof Source) {
                InputSource inputSource = XmlPayloadConverter.sourceToInputSource((Source)object);
                return this.getDocumentBuilder().parse(inputSource);
            }
            if (object instanceof File) {
                return this.getDocumentBuilder().parse((File)object);
            }
            if (object instanceof String) {
                return this.getDocumentBuilder().parse(new InputSource(new StringReader((String)object)));
            }
            if (object instanceof InputStream) {
                return this.getDocumentBuilder().parse((InputStream)object);
            }
            if (object instanceof byte[]) {
                return this.getDocumentBuilder().parse(new ByteArrayInputStream((byte[])object));
            }
        }
        catch (Exception e) {
            throw new XPathException("failed to parse " + String.valueOf(object.getClass()) + " payload '" + String.valueOf(object) + "'", e);
        }
        throw new XPathException("unsupported payload type [" + object.getClass().getName() + "]");
    }

    private static InputSource sourceToInputSource(Source source) {
        InputSource inputSource = SAXSource.sourceToInputSource(source);
        if (inputSource == null) {
            inputSource = new InputSource(source.getSystemId());
        }
        return inputSource;
    }

    protected Document nodeToDocument(Node node) {
        if (node instanceof Document) {
            return (Document)node;
        }
        Document document = this.getDocumentBuilder().newDocument();
        document.appendChild(document.importNode(node, true));
        return document;
    }

    public Node convertToNode(Object object) {
        Node node = object instanceof Node ? (Node)object : (object instanceof DOMSource ? ((DOMSource)object).getNode() : this.convertToDocument(object));
        return node;
    }

    protected synchronized DocumentBuilder getDocumentBuilder() {
        try {
            return this.documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new XPathException("failed to create a new DocumentBuilder", e);
        }
    }
}

