/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.policy.api;

import java.util.Map;

public interface PolicyResult {
    public int statusCode();

    public String message();

    public String key();

    public Map<String, Object> parameters();

    public String contentType();

    public static PolicyResult build(final int statusCode, final String key, final String message, final Map<String, Object> parameters, final String contentType) {
        return new PolicyResult(){

            @Override
            public int statusCode() {
                return statusCode;
            }

            @Override
            public String message() {
                return message;
            }

            @Override
            public String key() {
                return key;
            }

            @Override
            public Map<String, Object> parameters() {
                return parameters;
            }

            @Override
            public String contentType() {
                return contentType;
            }
        };
    }

    public static PolicyResult failure(String message) {
        return PolicyResult.failure(500, message);
    }

    public static PolicyResult failure(int statusCode, String message) {
        return PolicyResult.build(statusCode, null, message, null, "text/plain");
    }

    public static PolicyResult failure(String key, int statusCode, String message) {
        return PolicyResult.build(statusCode, key, message, null, "text/plain");
    }

    public static PolicyResult failure(String key, int statusCode, String message, Map<String, Object> parameters) {
        return PolicyResult.build(statusCode, key, message, parameters, "text/plain");
    }

    public static PolicyResult failure(String key, String message) {
        return PolicyResult.failure(key, 500, message);
    }

    public static PolicyResult failure(String key, String message, Map<String, Object> parameters) {
        return PolicyResult.failure(key, 500, message, parameters);
    }

    public static PolicyResult failure(int statusCode, String message, String contentType) {
        return PolicyResult.build(statusCode, null, message, null, contentType);
    }

    public static PolicyResult failure(String key, int statusCode, String message, String contentType) {
        return PolicyResult.build(statusCode, key, message, null, contentType);
    }
}

