/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.common.event.impl;

import io.gravitee.common.event.Event;
import io.gravitee.common.event.EventListener;
import io.gravitee.common.event.EventManager;
import io.gravitee.common.event.impl.SimpleEvent;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventManagerImpl
implements EventManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EventManagerImpl.class);
    private final Map<ComparableEventType<? extends Enum<?>>, List<EventListenerSubscription<?, ?>>> listeners = new ConcurrentHashMap();

    @Override
    public <T extends Enum<T>, S> void publishEvent(T type, S content) {
        this.publishEvent(new SimpleEvent<T, S>(type, content));
    }

    @Override
    public <T extends Enum<T>, S> void publishEvent(Event<T, S> event) {
        log.debug("Publish event {} - {}", event.type(), event.content());
        List<EventListenerSubscription<?, ?>> eventTypeListeners = this.listeners.get(new ComparableEventType(event.type().getClass()));
        if (eventTypeListeners != null && !eventTypeListeners.isEmpty()) {
            eventTypeListeners.stream().filter(wrapper -> wrapper.events().contains(event.type())).forEach(wrapper -> wrapper.eventListener().onEvent(event));
        }
    }

    @Override
    public <T extends Enum<T>> void subscribeForEvents(EventListener<T, ?> eventListener, T ... eventTypes) {
        if (eventTypes.length > 0) {
            Class<?> eventTypeClass = eventTypes[0].getClass();
            EnumSet<T[]> eventTypesSet = EnumSet.of(eventTypes[0], eventTypes);
            this.addEventListener(eventListener, eventTypeClass, eventTypesSet);
        }
    }

    @Override
    public <T extends Enum<T>> void subscribeForEvents(EventListener<T, ?> eventListener, Class<T> eventTypeClass) {
        this.addEventListener(eventListener, eventTypeClass, EnumSet.allOf(eventTypeClass));
    }

    private <T extends Enum<T>> void addEventListener(EventListener<T, ?> eventListener, Class<T> eventTypeClass, Set<T> eventTypes) {
        log.debug("Register new listener {} for event type {}", (Object)eventListener.getClass().getSimpleName(), eventTypeClass);
        this.listeners.compute(new ComparableEventType<T>(eventTypeClass), (k, v) -> {
            if (v == null) {
                v = new CopyOnWriteArrayList();
            }
            v.add(new EventListenerSubscription(eventListener, eventTypes));
            return v;
        });
    }

    @Override
    public <T extends Enum<T>> void unsubscribeForEvents(EventListener<T, ?> eventListener, Class<T> eventTypesClass) {
        this.removeEventListener(eventListener, eventTypesClass, EnumSet.allOf(eventTypesClass));
    }

    @Override
    public <T extends Enum<T>> void unsubscribeForEvents(EventListener<T, ?> eventListener, T ... eventTypes) {
        if (eventTypes.length > 0) {
            Class<?> eventTypeClass = eventTypes[0].getClass();
            EnumSet<T[]> eventTypesSet = EnumSet.of(eventTypes[0], eventTypes);
            this.removeEventListener(eventListener, eventTypeClass, eventTypesSet);
        }
    }

    private <T extends Enum<T>> void removeEventListener(EventListener<T, ?> eventListener, Class<T> eventTypeClass, Set<T> eventTypes) {
        log.debug("Unregister listener {} for event type {}", (Object)eventListener.getClass().getSimpleName(), eventTypeClass);
        this.listeners.computeIfPresent(new ComparableEventType<T>(eventTypeClass), (k, v) -> {
            HashSet removedEventListener = new HashSet();
            v.stream().filter(eventListenerSubscription -> eventListenerSubscription.eventListener.equals(eventListener)).forEach(eventListenerSubscription -> {
                eventListenerSubscription.events.removeAll(eventTypes);
                if (eventListenerSubscription.events.isEmpty()) {
                    removedEventListener.add(eventListenerSubscription);
                }
            });
            for (EventListenerSubscription eventListenerSubscription2 : removedEventListener) {
                v.remove(eventListenerSubscription2);
            }
            if (v.isEmpty()) {
                return null;
            }
            return v;
        });
    }

    private record ComparableEventType<T extends Enum<T>>(Class<? extends T> wrappedClass) implements Comparable<ComparableEventType<T>>
    {
        @Override
        public int compareTo(ComparableEventType<T> o) {
            return this.wrappedClass.getCanonicalName().compareTo(o.wrappedClass.getCanonicalName());
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof ComparableEventType)) {
                return false;
            }
            return this.compareTo((ComparableEventType)o) == 0;
        }
    }

    private record EventListenerSubscription<T extends Enum<T>, S>(EventListener<T, S> eventListener, Set<T> events) {
    }
}

