/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.common.util;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;

public class LinkedCaseInsensitiveMap<V>
extends LinkedHashMap<String, V> {
    private final Map<String, String> caseInsensitiveKeys;
    private final Locale locale;

    public LinkedCaseInsensitiveMap() {
        this((Locale)null);
    }

    public LinkedCaseInsensitiveMap(Locale locale) {
        this.caseInsensitiveKeys = new HashMap<String, String>();
        this.locale = locale != null ? locale : Locale.getDefault();
    }

    public LinkedCaseInsensitiveMap(int initialCapacity) {
        this(initialCapacity, null);
    }

    public LinkedCaseInsensitiveMap(int initialCapacity, Locale locale) {
        super(initialCapacity);
        this.caseInsensitiveKeys = new HashMap<String, String>(initialCapacity);
        this.locale = locale != null ? locale : Locale.getDefault();
    }

    @Override
    public V put(String key, V value) {
        String oldKey = this.caseInsensitiveKeys.put(this.convertKey(key), key);
        if (oldKey != null && !oldKey.equals(key)) {
            super.remove(oldKey);
        }
        return super.put(key, value);
    }

    @Override
    public void putAll(Map<? extends String, ? extends V> map) {
        if (map.isEmpty()) {
            return;
        }
        for (Map.Entry<String, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public boolean containsKey(Object key) {
        return key instanceof String && this.caseInsensitiveKeys.containsKey(this.convertKey((String)key));
    }

    @Override
    public V get(Object key) {
        if (key instanceof String) {
            return super.get(this.caseInsensitiveKeys.get(this.convertKey((String)key)));
        }
        return null;
    }

    @Override
    public V remove(Object key) {
        if (key instanceof String) {
            return super.remove(this.caseInsensitiveKeys.remove(this.convertKey((String)key)));
        }
        return null;
    }

    @Override
    public void clear() {
        this.caseInsensitiveKeys.clear();
        super.clear();
    }

    @Override
    public V getOrDefault(Object key, V defaultValue) {
        if (key instanceof String) {
            return super.getOrDefault(this.caseInsensitiveKeys.get(this.convertKey((String)key)), defaultValue);
        }
        return null;
    }

    @Override
    public V putIfAbsent(String key, V value) {
        if (!this.caseInsensitiveKeys.containsKey(this.convertKey(key))) {
            this.caseInsensitiveKeys.put(this.convertKey(key), key);
            return super.put(key, value);
        }
        return this.get(key);
    }

    @Override
    public V computeIfAbsent(String key, Function<? super String, ? extends V> mappingFunction) {
        if (!this.caseInsensitiveKeys.containsKey(this.convertKey(key))) {
            this.caseInsensitiveKeys.put(this.convertKey(key), key);
            return super.computeIfAbsent(key, mappingFunction);
        }
        return this.get(key);
    }

    @Override
    public V computeIfPresent(String key, BiFunction<? super String, ? super V, ? extends V> remappingFunction) {
        String oldKey = this.caseInsensitiveKeys.put(this.convertKey(key), key);
        if (oldKey != null) {
            if (!oldKey.equals(key)) {
                super.remove(oldKey);
            }
            return super.compute(key, remappingFunction);
        }
        return null;
    }

    @Override
    public V replace(String key, V value) {
        String oldKey = this.caseInsensitiveKeys.put(this.convertKey(key), key);
        if (oldKey != null) {
            Object oldValue = super.get(oldKey);
            if (oldKey.equals(key)) {
                super.replace(key, value);
            } else {
                super.remove(oldKey);
                super.put(key, value);
            }
            return oldValue;
        }
        return null;
    }

    public Set<String> insensitiveKeySet() {
        return this.caseInsensitiveKeys.keySet();
    }

    public Locale getLocale() {
        return this.locale;
    }

    protected String convertKey(String key) {
        return key.toLowerCase(this.locale);
    }
}

