/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.common.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Supplier;
import lombok.Generated;

public final class Maps {
    public static <K, V> MapBuilder<K, V> builder() {
        return Maps.builder(HashMap::new);
    }

    public static <K, V> MapBuilder<K, V> builder(Supplier<Map<K, V>> mapSupplier) {
        return new MapBuilder<K, V>(mapSupplier.get());
    }

    public static <K, V> ConcurrentMapBuilder<K, V> concurrentBuilder() {
        return Maps.concurrentBuilder(ConcurrentHashMap::new);
    }

    public static <K, V> ConcurrentMapBuilder<K, V> concurrentBuilder(Supplier<ConcurrentMap<K, V>> mapSupplier) {
        return new ConcurrentMapBuilder<K, V>(mapSupplier.get());
    }

    @Generated
    private Maps() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static class MapBuilder<K, V>
    extends BaseBuilder<Map<K, V>, K, V> {
        private boolean unmodifiable;

        public MapBuilder(Map<K, V> map) {
            super(map);
        }

        public MapBuilder<K, V> put(K key, V value) {
            super.put(key, value);
            return this;
        }

        public MapBuilder<K, V> unmodifiable(boolean unmodifiable) {
            this.unmodifiable = unmodifiable;
            return this;
        }

        @Override
        public Map<K, V> build() {
            if (this.unmodifiable) {
                return Collections.unmodifiableMap(super.build());
            }
            return super.build();
        }
    }

    public static class ConcurrentMapBuilder<K, V>
    extends BaseBuilder<ConcurrentMap<K, V>, K, V> {
        public ConcurrentMapBuilder(ConcurrentMap<K, V> map) {
            super(map);
        }

        public ConcurrentMapBuilder<K, V> put(K key, V value) {
            super.put(key, value);
            return this;
        }
    }

    private static class BaseBuilder<M extends Map<K, V>, K, V> {
        protected final M map;

        public BaseBuilder(M map) {
            this.map = map;
        }

        public BaseBuilder<M, K, V> put(K key, V value) {
            this.map.put(key, value);
            return this;
        }

        public M build() {
            return this.map;
        }
    }
}

