/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.common.util;

import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.core.env.MapPropertySource;
import org.springframework.util.Assert;

public class RelaxedPropertySource
extends MapPropertySource {
    @Autowired
    GenericConversionService conversionService;

    public RelaxedPropertySource(String name, Map<String, Object> source) {
        super(name, source);
    }

    public boolean containsProperty(String name) {
        boolean contains;
        boolean bl = contains = this.getProperty(name) != null;
        if (!contains && name.contains("[")) {
            return this.getProperty(this.encodedArray(name)) != null;
        }
        return contains;
    }

    public Object getProperty(String name) {
        String actualName = this.resolvePropertyName(name);
        if (this.logger.isDebugEnabled() && !name.equals(actualName)) {
            this.logger.debug((Object)String.format("PropertySource [%s] does not contain '%s', but found equivalent '%s'", this.getName(), name, actualName));
        }
        return super.getProperty(actualName);
    }

    private String resolvePropertyName(String name) {
        Assert.notNull((Object)name, (String)"Property name must not be null");
        String resolvedName = this.checkPropertyName(name);
        if (resolvedName != null) {
            return resolvedName;
        }
        String uppercasedName = name.toUpperCase();
        if (!name.equals(uppercasedName) && (resolvedName = this.checkPropertyName(uppercasedName)) != null) {
            return resolvedName;
        }
        return name;
    }

    private String checkPropertyName(String name) {
        if (this.containsKey(name)) {
            return name;
        }
        String noDotName = name.replace('.', '_');
        if (!name.equals(noDotName) && this.containsKey(noDotName)) {
            return noDotName;
        }
        String noHyphenName = name.replace("-", "");
        if (!name.equals(noHyphenName) && this.containsKey(noHyphenName)) {
            return noHyphenName;
        }
        String noHyphenNameAndDotName = noDotName.replace("-", "");
        if (!name.equals(noHyphenNameAndDotName) && this.containsKey(noHyphenNameAndDotName)) {
            return noHyphenNameAndDotName;
        }
        if (name.split(":")[0].contains("[")) {
            return this.checkPropertyName(this.encodedArray(name));
        }
        return null;
    }

    private String encodedArray(String name) {
        String[] keyWithDefault = name.split(":");
        String encodedKey = keyWithDefault[0];
        if (keyWithDefault[0].contains("[")) {
            encodedKey = encodedKey.replace("[", ".").replace("]", "");
        }
        return keyWithDefault.length == 1 ? encodedKey : encodedKey + ":" + keyWithDefault[1];
    }

    private boolean containsKey(String name) {
        return this.isSecurityManagerPresent() ? ((Map)this.source).keySet().contains(name) : ((Map)this.source).containsKey(name);
    }

    protected boolean isSecurityManagerPresent() {
        return System.getSecurityManager() != null;
    }
}

