/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.common.util;

import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TemplatedValueHashMap
extends HashMap<String, String> {
    private static final Pattern PATTERN = Pattern.compile("\\{\\{(.*?)\\}\\}");

    @Override
    public String get(Object key) {
        List list;
        if (key instanceof List && !(list = (List)key).isEmpty()) {
            String value = (String)super.get(list.get(0));
            return value == null ? null : this.resolve(value);
        }
        String value = (String)super.get(key);
        return value == null ? null : this.resolve(value);
    }

    @Override
    public String getOrDefault(Object key, String defaultValue) {
        String value = super.getOrDefault(key, defaultValue);
        return value == null ? null : this.resolve(value);
    }

    private String resolve(String initialValue) {
        if (initialValue == null || initialValue.isEmpty()) {
            return initialValue;
        }
        Matcher matcher = PATTERN.matcher(initialValue);
        StringBuffer sb = new StringBuffer(initialValue.length());
        while (matcher.find()) {
            String text = matcher.group(1);
            String value = this.get(text);
            if (value != null) {
                matcher.appendReplacement(sb, Matcher.quoteReplacement(value));
                continue;
            }
            throw new IllegalStateException("A value is missing for key [" + text + "]");
        }
        matcher.appendTail(sb);
        return sb.toString();
    }
}

