/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.common.utils;

import io.reactivex.rxjava3.core.CompletableTransformer;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.FlowableTransformer;
import io.reactivex.rxjava3.core.Maybe;
import io.reactivex.rxjava3.core.MaybeTransformer;
import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.core.SingleTransformer;
import io.reactivex.rxjava3.functions.Function;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import lombok.Generated;
import org.reactivestreams.Publisher;

public class RxHelper {
    public static final Predicate<Throwable> TRUE_PREDICATE = t -> true;
    public static final Predicate<Object> FALSE_PREDICATE = o -> false;
    public static final String RETRY_PREDICATE_IS_NULL_ERROR = "retryPredicate is null";

    public static <R> FlowableTransformer<R, R> mergeWithFirst(Flowable<R> other) {
        return upstream -> other.materialize().mergeWith((Publisher)upstream.materialize()).dematerialize(n -> n);
    }

    public static <R> FlowableTransformer<R, R> delayElement(int delay, TimeUnit timeUnit) {
        return RxHelper.delayElement(delay, timeUnit, FALSE_PREDICATE);
    }

    public static <R> FlowableTransformer<R, R> delayElement(int delay, TimeUnit timeUnit, Predicate<? super R> skipDelayPredicate) {
        return upstream -> upstream.concatMapSingle(e -> {
            if (skipDelayPredicate.test((Object)e)) {
                return Single.just((Object)e);
            }
            return Single.just((Object)e).delay((long)delay, timeUnit);
        });
    }

    public static <R> FlowableTransformer<R, R> retryFlowable(int times, int retryInterval, TimeUnit timeUnit) {
        return RxHelper.retryFlowable(times, retryInterval, timeUnit, TRUE_PREDICATE);
    }

    public static <R> FlowableTransformer<R, R> retryFlowable(int times, int retryInterval, TimeUnit timeUnit, Predicate<Throwable> retryPredicate) {
        Objects.requireNonNull(retryPredicate, RETRY_PREDICATE_IS_NULL_ERROR);
        Predicate<Throwable> skipThrowable = retryPredicate.negate();
        return upstream -> upstream.retryWhen(throwables -> throwables.compose(RxHelper.delayElement(retryInterval, timeUnit, skipThrowable)).compose(RxHelper.takeThenThrow(times, skipThrowable)));
    }

    public static <R> MaybeTransformer<R, R> retryMaybe(int times, int retryInterval, TimeUnit timeUnit) {
        return RxHelper.retryMaybe(times, retryInterval, timeUnit, TRUE_PREDICATE);
    }

    public static <R> MaybeTransformer<R, R> retryMaybe(int times, int retryInterval, TimeUnit timeUnit, Predicate<Throwable> retryPredicate) {
        Predicate<Throwable> skipThrowable = retryPredicate.negate();
        return upstream -> upstream.retryWhen(throwables -> throwables.compose(RxHelper.delayElement(retryInterval, timeUnit, skipThrowable)).compose(RxHelper.takeThenThrow(times, skipThrowable)));
    }

    public static <R> SingleTransformer<R, R> retrySingle(int times, int retryInterval, TimeUnit timeUnit) {
        return RxHelper.retrySingle(times, retryInterval, timeUnit, TRUE_PREDICATE);
    }

    public static <R> SingleTransformer<R, R> retrySingle(int times, int retryInterval, TimeUnit timeUnit, Predicate<Throwable> retryPredicate) {
        Predicate<Throwable> skipThrowable = retryPredicate.negate();
        return upstream -> upstream.retryWhen(throwables -> throwables.compose(RxHelper.delayElement(retryInterval, timeUnit, skipThrowable)).compose(RxHelper.takeThenThrow(times, skipThrowable)));
    }

    public static CompletableTransformer retry(int times, int retryInterval, TimeUnit timeUnit) {
        return RxHelper.retry(times, retryInterval, timeUnit, TRUE_PREDICATE);
    }

    public static CompletableTransformer retry(int times, int retryInterval, TimeUnit timeUnit, Predicate<Throwable> retryPredicate) {
        Objects.requireNonNull(retryPredicate, RETRY_PREDICATE_IS_NULL_ERROR);
        Predicate<Throwable> skipThrowable = retryPredicate.negate();
        return upstream -> upstream.retryWhen(throwables -> throwables.compose(RxHelper.delayElement(retryInterval, timeUnit, skipThrowable)).compose(RxHelper.takeThenThrow(times, skipThrowable)));
    }

    private static <R extends Throwable> FlowableTransformer<R, R> takeThenThrow(int limit, Predicate<R> throwDirectlyPredicate) {
        AtomicInteger tries = new AtomicInteger(0);
        return upstream -> upstream.flatMapMaybe(throwable -> {
            if (tries.incrementAndGet() > limit || throwDirectlyPredicate.test(throwable)) {
                return Maybe.error((Throwable)throwable);
            }
            return Maybe.just((Object)throwable);
        });
    }

    public static Function<? super Flowable<Throwable>, ? extends Publisher<?>> retryExponentialBackoff(long initialDelay, TimeUnit timeUnit) {
        return RxHelper.retryExponentialBackoff(initialDelay, -1L, timeUnit);
    }

    public static Function<? super Flowable<Throwable>, ? extends Publisher<?>> retryExponentialBackoff(long initialDelay, long maxDelay, TimeUnit timeUnit) {
        return RxHelper.retryExponentialBackoff(initialDelay, maxDelay, timeUnit, 2.0);
    }

    public static Function<? super Flowable<Throwable>, ? extends Publisher<?>> retryExponentialBackoff(long initialDelay, long maxDelay, TimeUnit timeUnit, double factor) {
        return RxHelper.retryExponentialBackoff(initialDelay, maxDelay, timeUnit, factor, TRUE_PREDICATE);
    }

    public static Function<? super Flowable<Throwable>, ? extends Publisher<?>> retryExponentialBackoff(long initialDelay, long maxDelay, TimeUnit timeUnit, double factor, Predicate<Throwable> retryPredicate) {
        return RxHelper.retryExponentialBackoff(initialDelay, maxDelay, timeUnit, factor, -1, retryPredicate);
    }

    public static Function<? super Flowable<Throwable>, ? extends Publisher<?>> retryExponentialBackoff(long initialDelay, long maxDelay, TimeUnit timeUnit, double factor, int maxAttempt, Predicate<Throwable> retryPredicate) {
        Objects.requireNonNull(retryPredicate, RETRY_PREDICATE_IS_NULL_ERROR);
        return attempts -> attempts.flatMapSingle(throwable -> {
            if (retryPredicate.test((Throwable)throwable)) {
                return Single.just((Object)throwable);
            }
            return Single.error((Throwable)throwable);
        }).zipWith((Publisher)Flowable.range((int)1, (int)Integer.MAX_VALUE), (x$0, x$1) -> {
            record Attempt(Throwable throwable, int occurrence) {
            }
            return new Attempt((Throwable)x$0, (int)x$1);
        }).map(attempt -> {
            if (maxAttempt > 0 && attempt.occurrence() > maxAttempt) {
                throw attempt.throwable();
            }
            long delayMs = Math.round(Math.pow(factor, (double)attempt.occurrence() - 1.0) * (double)timeUnit.toMillis(initialDelay));
            if (maxDelay != -1L) {
                long maxDelayMs = timeUnit.toMillis(maxDelay);
                delayMs = Math.min(maxDelayMs, delayMs);
            }
            return delayMs;
        }).flatMap(delayMs -> Flowable.timer((long)delayMs, (TimeUnit)TimeUnit.MILLISECONDS));
    }

    @Generated
    private RxHelper() {
    }
}

