/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.node.plugin.cache.common;

import com.github.benmanes.caffeine.cache.Caffeine;
import io.gravitee.common.utils.UUID;
import io.gravitee.node.api.cache.Cache;
import io.gravitee.node.api.cache.CacheConfiguration;
import io.gravitee.node.api.cache.CacheListener;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemoryCache<K, V>
implements Cache<K, V> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InMemoryCache.class);
    private final String name;
    private final CacheConfiguration configuration;
    private final com.github.benmanes.caffeine.cache.Cache<K, ExpiringValue<V>> internalCache;
    private final Map<String, CacheListener<K, V>> cacheListeners = new HashMap<String, CacheListener<K, V>>();
    private static final ExecutorService executorService = Executors.newSingleThreadExecutor(r -> new Thread(r, "gio-cache-in-memory-listeners"));

    public InMemoryCache(String name, CacheConfiguration configuration) {
        this.name = name;
        this.configuration = configuration;
        Caffeine cacheBuilder = Caffeine.newBuilder();
        cacheBuilder.executor((Executor)executorService);
        if (configuration.getMaxSize() > 0L) {
            cacheBuilder.maximumSize(configuration.getMaxSize());
        }
        if (configuration.getTimeToIdleInMs() > 0L) {
            cacheBuilder.expireAfterAccess(configuration.getTimeToIdleInMs(), TimeUnit.MILLISECONDS);
        }
        if (configuration.getTimeToLiveInMs() > 0L) {
            cacheBuilder.expireAfterWrite(configuration.getTimeToLiveInMs(), TimeUnit.MILLISECONDS);
        }
        cacheBuilder.removalListener((k, v, cause) -> this.cacheListeners.forEach((id, listener) -> {
            try {
                Object typeKey = k;
                ExpiringValue expiringValue = (ExpiringValue)v;
                Object value = expiringValue != null ? expiringValue.value : null;
                switch (cause) {
                    case EXPLICIT: {
                        if (expiringValue != null && expiringValue.hasExpired()) {
                            listener.onEntryExpired(typeKey, value);
                            break;
                        }
                        listener.onEntryEvicted(typeKey, value);
                        break;
                    }
                    case EXPIRED: {
                        listener.onEntryExpired(typeKey, value);
                        break;
                    }
                    case SIZE: {
                        listener.onEntryEvicted(typeKey, value);
                        break;
                    }
                }
            }
            catch (Exception e) {
                log.error("Unable to trigger cache listener");
            }
        }));
        this.internalCache = cacheBuilder.build();
    }

    public String getName() {
        return this.name;
    }

    public int size() {
        return (int)this.internalCache.estimatedSize();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Collection<V> values() {
        return this.internalCache.asMap().entrySet().stream().map(entry -> {
            Object key = entry.getKey();
            ExpiringValue expiringValue = (ExpiringValue)entry.getValue();
            if (expiringValue.hasExpired()) {
                this.internalCache.invalidate(key);
                return null;
            }
            return expiringValue.value;
        }).filter(Objects::nonNull).toList();
    }

    public Set<K> keys() {
        return this.internalCache.asMap().keySet();
    }

    public Set<Map.Entry<K, V>> entrySet() {
        return this.internalCache.asMap().entrySet().stream().map(entry -> {
            Object key = entry.getKey();
            ExpiringValue expiringValue = (ExpiringValue)entry.getValue();
            if (expiringValue.hasExpired()) {
                this.internalCache.invalidate(key);
                return null;
            }
            return new AbstractMap.SimpleEntry(key, expiringValue.value);
        }).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    public boolean containsKey(K key) {
        return this.get(key) != null;
    }

    public V get(K key) {
        ExpiringValue expiringValue = (ExpiringValue)this.internalCache.getIfPresent(key);
        if (expiringValue != null) {
            if (expiringValue.hasExpired()) {
                this.internalCache.invalidate(key);
                return null;
            }
            return (V)expiringValue.value;
        }
        return null;
    }

    public V put(K key, V value) {
        return this.put(key, value, 0L, TimeUnit.MILLISECONDS);
    }

    public V put(K key, V value, long ttl, TimeUnit ttlUnit) {
        long ttlMillis = this.computeTTLMillis(ttl, ttlUnit);
        V oldValue = this.get(key);
        long expirationTimeMillis = this.computeExpirationTimeMillis(ttlMillis);
        this.internalCache.put(key, new ExpiringValue<V>(value, expirationTimeMillis));
        this.notifyListeners(key, value, oldValue);
        return oldValue;
    }

    public void putAll(Map<? extends K, ? extends V> values) {
        HashMap oldValues = new HashMap();
        if (!this.cacheListeners.isEmpty()) {
            values.keySet().forEach(key -> {
                V oldValue = this.get(key);
                if (oldValue != null) {
                    oldValues.put(key, oldValue);
                }
            });
        }
        Map<Object, ExpiringValue> expiringValueMap = values.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> new ExpiringValue(e.getValue(), 0L)));
        this.internalCache.putAll(expiringValueMap);
        executorService.execute(() -> this.cacheListeners.forEach((id, listener) -> values.forEach((key, value) -> {
            if (!oldValues.containsKey(key)) {
                listener.onEntryAdded(key, value);
            } else {
                listener.onEntryUpdated(key, oldValues.get(key), value);
            }
        })));
    }

    public V computeIfAbsent(K key, Function<? super K, ? extends V> remappingFunction) {
        this.internalCache.asMap().computeIfAbsent(key, k -> {
            Object applied = remappingFunction.apply((K)k);
            this.notifyListeners(k, applied, null);
            return InMemoryCache.buildExpiringValue(applied);
        });
        return this.get(key);
    }

    public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        this.internalCache.asMap().computeIfPresent(key, (k, v) -> {
            Object applied = remappingFunction.apply((K)k, (V)v.value);
            this.notifyListeners(k, applied, v.value);
            return InMemoryCache.buildExpiringValue(applied);
        });
        return this.get(key);
    }

    public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        this.internalCache.asMap().compute(key, (k, v) -> {
            V old = null;
            if (v != null) {
                old = (V)v.value;
            }
            Object applied = remappingFunction.apply((K)k, (V)old);
            this.notifyListeners(k, applied, old);
            return InMemoryCache.buildExpiringValue(applied);
        });
        return this.get(key);
    }

    public V evict(K key) {
        V currentValue = this.get(key);
        this.internalCache.invalidate(key);
        return currentValue;
    }

    public void clear() {
        this.internalCache.invalidateAll();
    }

    public String addCacheListener(CacheListener<K, V> cacheListener) {
        String listenerCacheId = UUID.random().toString();
        this.cacheListeners.put(listenerCacheId, cacheListener);
        return listenerCacheId;
    }

    public boolean removeCacheListener(String listenerCacheId) {
        return this.cacheListeners.remove(listenerCacheId) != null;
    }

    private long computeTTLMillis(long ttl, TimeUnit ttlUnit) {
        long ttlMillis = TimeUnit.MILLISECONDS.convert(ttl, ttlUnit);
        if (this.configuration.getTimeToLiveInMs() > 0L && this.configuration.getTimeToLiveInMs() < ttlMillis) {
            throw new IllegalArgumentException("TTL can't be bigger than ttl defined in the cache configuration");
        }
        return ttlMillis;
    }

    private long computeExpirationTimeMillis(long ttlMillis) {
        return ttlMillis > 0L ? System.currentTimeMillis() + ttlMillis : 0L;
    }

    private void notifyListeners(K key, V value, V oldValue) {
        executorService.execute(() -> this.cacheListeners.forEach((id, listener) -> {
            if (oldValue == null) {
                listener.onEntryAdded(key, value);
            } else {
                listener.onEntryUpdated(key, oldValue, value);
            }
        }));
    }

    private static <V> ExpiringValue<V> buildExpiringValue(V applied) {
        return applied == null ? null : new ExpiringValue<V>(applied, 0L);
    }

    private static class ExpiringValue<T> {
        private final T value;
        private final long expirationTimeMillis;

        public boolean hasExpired() {
            return this.expirationTimeMillis > 0L && this.expirationTimeMillis <= System.currentTimeMillis();
        }

        @Generated
        public ExpiringValue(T value, long expirationTimeMillis) {
            this.value = value;
            this.expirationTimeMillis = expirationTimeMillis;
        }
    }
}

