/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.policy.transformqueryparams;

import io.gravitee.gateway.api.ExecutionContext;
import io.gravitee.gateway.api.Request;
import io.gravitee.gateway.api.Response;
import io.gravitee.policy.api.PolicyChain;
import io.gravitee.policy.api.annotations.OnRequest;
import io.gravitee.policy.transformqueryparams.configuration.TransformQueryParametersPolicyConfiguration;
import java.util.LinkedList;
import java.util.List;

public class TransformQueryParametersPolicy {
    private static final String WHITESPACE = " ";
    private static final String ENCODED_WHITESPACE = "%20";
    private final TransformQueryParametersPolicyConfiguration transformQueryParametersPolicyConfiguration;

    public TransformQueryParametersPolicy(TransformQueryParametersPolicyConfiguration transformQueryParametersPolicyConfiguration) {
        this.transformQueryParametersPolicyConfiguration = transformQueryParametersPolicyConfiguration;
    }

    @OnRequest
    public void onRequest(Request request, Response response, ExecutionContext executionContext, PolicyChain policyChain) {
        if (this.transformQueryParametersPolicyConfiguration.isClearAll()) {
            request.parameters().clear();
        }
        if (this.transformQueryParametersPolicyConfiguration.getAddQueryParameters() != null) {
            this.transformQueryParametersPolicyConfiguration.getAddQueryParameters().forEach(queryParameter -> {
                if (queryParameter.getName() != null && !queryParameter.getName().trim().isEmpty()) {
                    try {
                        List<String> values;
                        String extValue = queryParameter.getValue() != null ? executionContext.getTemplateEngine().convert(queryParameter.getValue()) : null;
                        String name = queryParameter.getName().contains(WHITESPACE) ? queryParameter.getName().replaceAll(WHITESPACE, ENCODED_WHITESPACE) : queryParameter.getName();
                        if (extValue.contains(WHITESPACE)) {
                            extValue = extValue.replaceAll(WHITESPACE, ENCODED_WHITESPACE);
                        }
                        if (queryParameter.isAppendToExistingArray()) {
                            values = (List)request.parameters().get((Object)name);
                            if (values == null) {
                                values = new LinkedList();
                            }
                        } else {
                            values = new LinkedList<String>();
                        }
                        values.add(extValue);
                        request.parameters().put((Object)name, values);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }
        if (!this.transformQueryParametersPolicyConfiguration.isClearAll() && this.transformQueryParametersPolicyConfiguration.getRemoveQueryParameters() != null) {
            this.transformQueryParametersPolicyConfiguration.getRemoveQueryParameters().forEach(queryParameterName -> {
                if (queryParameterName != null && !queryParameterName.trim().isEmpty()) {
                    request.parameters().remove(queryParameterName);
                }
            });
        }
        policyChain.doNext(request, response);
    }
}

