/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.reporter.file;

import io.gravitee.common.service.AbstractService;
import io.gravitee.reporter.api.Reportable;
import io.gravitee.reporter.api.Reporter;
import io.gravitee.reporter.file.MetricsType;
import io.gravitee.reporter.file.config.FileReporterConfiguration;
import io.gravitee.reporter.file.formatter.Formatter;
import io.gravitee.reporter.file.formatter.FormatterFactory;
import io.gravitee.reporter.file.vertx.VertxFileWriter;
import io.vertx.core.CompositeFuture;
import io.vertx.core.Vertx;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public class FileReporter
extends AbstractService
implements Reporter {
    private final Logger logger = LoggerFactory.getLogger(FileReporter.class);
    @Autowired
    private Vertx vertx;
    @Autowired
    private FileReporterConfiguration configuration;
    @Value(value="${reporters.file.enabled:false}")
    private boolean enabled;
    private Map<Class<? extends Reportable>, VertxFileWriter> writers = new HashMap<Class<? extends Reportable>, VertxFileWriter>(4);

    public void report(Reportable reportable) {
        this.writers.get(reportable.getClass()).write(reportable);
    }

    public boolean canHandle(Reportable reportable) {
        return this.enabled && this.writers.containsKey(reportable.getClass());
    }

    protected void doStart() throws Exception {
        if (this.enabled) {
            for (MetricsType type : MetricsType.values()) {
                Formatter formatter = FormatterFactory.getFormatter(this.configuration.getOutputType(), this.configuration.getRules(type));
                this.applicationContext.getAutowireCapableBeanFactory().autowireBean((Object)formatter);
                this.writers.put(type.getClazz(), new VertxFileWriter(this.vertx, type, formatter, this.configuration.getFilename() + "." + this.configuration.getOutputType().getExtension(), this.configuration));
            }
            CompositeFuture.join(this.writers.values().stream().map(VertxFileWriter::initialize).collect(Collectors.toList())).onComplete(event -> {
                if (event.succeeded()) {
                    this.logger.info("File reporter successfully started");
                } else {
                    this.logger.info("An error occurs while starting file reporter", event.cause());
                }
            });
        }
    }

    protected void doStop() throws Exception {
        if (this.enabled) {
            CompositeFuture.join(this.writers.values().stream().map(VertxFileWriter::stop).collect(Collectors.toList())).onComplete(event -> {
                if (event.succeeded()) {
                    this.logger.info("File reporter successfully stopped");
                } else {
                    this.logger.info("An error occurs while stopping file reporter", event.cause());
                }
            });
        }
    }
}

