/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.reporter.file.formatter;

import io.gravitee.reporter.api.configuration.Rules;
import io.gravitee.reporter.file.formatter.Formatter;
import io.gravitee.reporter.file.formatter.Type;
import io.gravitee.reporter.file.formatter.csv.CsvFormatter;
import io.gravitee.reporter.file.formatter.elasticsearch.ElasticsearchFormatter;
import io.gravitee.reporter.file.formatter.json.JsonFormatter;
import io.gravitee.reporter.file.formatter.msgpack.MsgPackFormatter;

public final class FormatterFactory {
    public static Formatter getFormatter(Type type, Rules rules) {
        switch (type) {
            case CSV: {
                return new CsvFormatter();
            }
            case MESSAGE_PACK: {
                return new MsgPackFormatter(rules);
            }
            case JSON: {
                return new JsonFormatter(rules);
            }
            case ELASTICSEARCH: {
                return new ElasticsearchFormatter();
            }
        }
        return new JsonFormatter(rules);
    }
}

