/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.reporter.file.formatter.elasticsearch;

import io.gravitee.common.utils.UUID;
import io.gravitee.node.api.Node;
import io.gravitee.node.api.monitor.Monitor;
import io.gravitee.reporter.api.Reportable;
import io.gravitee.reporter.api.health.EndpointStatus;
import io.gravitee.reporter.api.http.Metrics;
import io.gravitee.reporter.api.log.Log;
import io.gravitee.reporter.file.formatter.AbstractFormatter;
import io.gravitee.reporter.file.formatter.elasticsearch.freemarker.FreeMarkerComponent;
import io.vertx.core.buffer.Buffer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.validator.routines.InetAddressValidator;
import org.springframework.beans.factory.annotation.Autowired;

public class ElasticsearchFormatter<T extends Reportable>
extends AbstractFormatter<T> {
    private final DateTimeFormatter dtf = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSS[XXX]").withZone(ZoneId.systemDefault());
    private final DateTimeFormatter sdf = DateTimeFormatter.ofPattern("yyyy.MM.dd").withZone(ZoneId.systemDefault());
    private static String hostname;
    @Autowired
    private Node node;
    @Autowired
    private FreeMarkerComponent freeMarkerComponent;

    @Override
    public Buffer format0(T data) {
        if (data instanceof Metrics) {
            return this.getSource((Metrics)data);
        }
        if (data instanceof EndpointStatus) {
            return this.getSource((EndpointStatus)data);
        }
        if (data instanceof Monitor) {
            return this.getSource((Monitor)data);
        }
        if (data instanceof Log) {
            return this.getSource((Log)data);
        }
        return null;
    }

    private Buffer getSource(Metrics metrics) {
        HashMap<String, Object> data = new HashMap<String, Object>(10);
        if (!InetAddressValidator.getInstance().isValid(metrics.getRemoteAddress())) {
            metrics.setRemoteAddress("0.0.0.0");
        }
        data.put("date", this.sdf.format(metrics.timestamp()));
        data.put("@timestamp", this.dtf.format(metrics.timestamp()));
        data.put("gateway", this.node.id());
        data.put("metrics", metrics);
        data.put("apiResponseTime", metrics.getApiResponseTimeMs() >= 0L ? Long.valueOf(metrics.getApiResponseTimeMs()) : null);
        data.put("proxyLatency", metrics.getProxyLatencyMs() >= 0L ? Long.valueOf(metrics.getProxyLatencyMs()) : null);
        data.put("requestContentLength", metrics.getRequestContentLength() >= 0L ? Long.valueOf(metrics.getRequestContentLength()) : null);
        data.put("responseContentLength", metrics.getResponseContentLength() >= 0L ? Long.valueOf(metrics.getResponseContentLength()) : null);
        return this.generateData("request.ftl", data);
    }

    private Buffer getSource(Log log) {
        HashMap<String, Object> data = new HashMap<String, Object>(5);
        data.put("date", this.sdf.format(log.timestamp()));
        data.put("@timestamp", this.dtf.format(log.timestamp()));
        data.put("gateway", this.node.id());
        data.put("log", log);
        return this.generateData("log.ftl", data);
    }

    private Buffer getSource(EndpointStatus endpointStatus) {
        HashMap<String, Object> data = new HashMap<String, Object>(5);
        data.put("date", this.sdf.format(endpointStatus.timestamp()));
        data.put("gateway", this.node.id());
        data.put("@timestamp", this.dtf.format(endpointStatus.timestamp()));
        data.put("status", endpointStatus);
        return this.generateData("health.ftl", data);
    }

    private Buffer getSource(Monitor monitor) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("date", this.sdf.format(monitor.timestamp()));
        data.put("id", UUID.random().toString());
        data.put("hostname", hostname);
        data.put("@timestamp", this.dtf.format(monitor.timestamp()));
        data.put("gateway", this.node.id());
        if (monitor.getOs() != null) {
            if (monitor.getOs().cpu != null) {
                data.put("percent", monitor.getOs().cpu.getPercent());
                if (monitor.getOs().cpu.getLoadAverage() != null && Arrays.stream(monitor.getOs().cpu.getLoadAverage()).anyMatch(load -> load != -1.0)) {
                    if (monitor.getOs().cpu.getLoadAverage()[0] != -1.0) {
                        data.put("load_average_1m", monitor.getOs().cpu.getLoadAverage()[0]);
                    }
                    if (monitor.getOs().cpu.getLoadAverage()[1] != -1.0) {
                        data.put("load_average_5m", monitor.getOs().cpu.getLoadAverage()[1]);
                    }
                    if (monitor.getOs().cpu.getLoadAverage()[2] != -1.0) {
                        data.put("load_average_15m", monitor.getOs().cpu.getLoadAverage()[2]);
                    }
                }
            }
            if (monitor.getOs().mem != null) {
                data.put("mem_total_in_bytes", monitor.getOs().mem.getTotal());
                data.put("mem_free_in_bytes", monitor.getOs().mem.getFree());
                data.put("mem_used_in_bytes", monitor.getOs().mem.getUsed());
                data.put("mem_free_percent", monitor.getOs().mem.getFreePercent());
                data.put("mem_used_percent", monitor.getOs().mem.getUsedPercent());
            }
        }
        if (monitor.getProcess() != null) {
            data.put("process_timestamp", monitor.getProcess().timestamp);
            data.put("open_file_descriptors", monitor.getProcess().openFileDescriptors);
            data.put("max_file_descriptors", monitor.getProcess().maxFileDescriptors);
            data.put("process_percent", monitor.getProcess().cpu.getPercent());
        }
        if (monitor.getJvm() != null) {
            data.put("jvm_timestamp", monitor.getJvm().timestamp);
            data.put("uptime_in_millis", monitor.getJvm().uptime);
            if (monitor.getJvm().mem != null) {
                data.put("heap_used_in_bytes", monitor.getJvm().mem.heapUsed);
                if (monitor.getJvm().mem.getHeapUsedPercent() >= 0) {
                    data.put("heap_used_percent", monitor.getJvm().mem.getHeapUsedPercent());
                }
                data.put("heap_committed_in_bytes", monitor.getJvm().mem.heapCommitted);
                data.put("heap_max_in_bytes", monitor.getJvm().mem.heapMax);
                data.put("non_heap_used_in_bytes", monitor.getJvm().mem.nonHeapUsed);
                data.put("non_heap_committed_in_bytes", monitor.getJvm().mem.nonHeapCommitted);
                data.put("pools", monitor.getJvm().mem.pools);
            }
            if (monitor.getJvm().threads != null) {
                data.put("count", monitor.getJvm().threads.getCount());
                data.put("peak_count", monitor.getJvm().threads.getPeakCount());
            }
            if (monitor.getJvm().gc != null) {
                data.put("collectors", monitor.getJvm().gc.collectors);
            }
        }
        return this.generateData("monitor.ftl", data);
    }

    private Buffer generateData(String templateName, Map<String, Object> data) {
        Buffer buffer;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            this.freeMarkerComponent.generateFromTemplate("/index/" + templateName, data, new OutputStreamWriter(baos));
            buffer = Buffer.buffer((byte[])baos.toByteArray());
        }
        catch (Throwable throwable) {
            try {
                try {
                    baos.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                return null;
            }
        }
        baos.close();
        return buffer;
    }

    static {
        try {
            hostname = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            hostname = "unknown";
        }
    }

    static final class Fields {
        static final String GATEWAY = "gateway";
        static final String HOSTNAME = "hostname";
        static final String SPECIAL_TIMESTAMP = "@timestamp";
        static final String TIMESTAMP = "timestamp";
        static final String PERCENT = "percent";
        static final String LOAD_AVERAGE_1M = "load_average_1m";
        static final String LOAD_AVERAGE_5M = "load_average_5m";
        static final String LOAD_AVERAGE_15M = "load_average_15m";
        static final String FREE_IN_BYTES = "free_in_bytes";
        static final String USED_IN_BYTES = "used_in_bytes";
        static final String TOTAL_IN_BYTES = "total_in_bytes";
        static final String FREE_PERCENT = "free_percent";
        static final String USED_PERCENT = "used_percent";
        static final String OPEN_FILE_DESCRIPTORS = "open_file_descriptors";
        static final String MAX_FILE_DESCRIPTORS = "max_file_descriptors";
        static final String UPTIME_IN_MILLIS = "uptime_in_millis";
        static final String HEAP_USED_IN_BYTES = "heap_used_in_bytes";
        static final String HEAP_USED_PERCENT = "heap_used_percent";
        static final String HEAP_MAX_IN_BYTES = "heap_max_in_bytes";
        static final String HEAP_COMMITTED_IN_BYTES = "heap_committed_in_bytes";
        static final String NON_HEAP_USED_IN_BYTES = "non_heap_used_in_bytes";
        static final String NON_HEAP_COMMITTED_IN_BYTES = "non_heap_committed_in_bytes";
        static final String POOLS = "pools";
        static final String COUNT = "count";
        static final String PEAK_COUNT = "peak_count";
        static final String COLLECTORS = "collectors";

        Fields() {
        }
    }
}

